/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.WhitespaceCheck;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPWhitespaceCheck
extends WhitespaceCheck {
    private static final Pattern _directiveLinePattern = Pattern.compile("<%@\n?.*%>");
    private static final Pattern _javaSourceInsideJSPLinePattern = Pattern.compile("<%=(.+?)%>");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        content = this._formatWhitespace(fileName, absolutePath, content);
        content = this._formatDirectivesWhitespace(content);
        content = StringUtil.replace(content, new String[]{"@page import", "@tag import", "\"%>", ")%>", "javascript: ", "){\n", "\n\n\n"}, new String[]{"@ page import", "@ tag import", "\" %>", ") %>", "javascript:", ") {\n", "\n\n"});
        return content;
    }

    @Override
    protected String formatDoubleSpace(String line) {
        String trimmedLine = StringUtil.trim(line);
        if (trimmedLine.startsWith("//") || trimmedLine.startsWith("#") || trimmedLine.startsWith("*")) {
            return line;
        }
        Matcher matcher = _javaSourceInsideJSPLinePattern.matcher(line);
        while (matcher.find()) {
            String group = matcher.group();
            line = StringUtil.replace(line, group, super.formatDoubleSpace(group));
        }
        return super.formatDoubleSpace(line);
    }

    private String _formatDirectivesWhitespace(String content) {
        Matcher matcher = _directiveLinePattern.matcher(content);
        while (matcher.find()) {
            String directiveLine = matcher.group();
            String newDirectiveLine = this.formatIncorrectSyntax(directiveLine, " =", "=", false);
            if (directiveLine.equals(newDirectiveLine = this.formatIncorrectSyntax(newDirectiveLine, "= ", "=", false))) continue;
            content = StringUtil.replace(content, directiveLine, newDirectiveLine);
        }
        return content.replaceAll("(\\s(page|taglib))\\s+((import|uri)=)", "$1 $3");
    }

    private String _formatWhitespace(String line, boolean javaSource) {
        String trimmedLine = StringUtil.trimLeading(line);
        line = this.formatWhitespace(line, trimmedLine, javaSource);
        if (javaSource) {
            return line;
        }
        Matcher matcher = _javaSourceInsideJSPLinePattern.matcher(line);
        while (matcher.find()) {
            String linePart = matcher.group(1);
            if (!linePart.startsWith(" ")) {
                return StringUtil.replace(line, matcher.group(), "<%= " + linePart + "%>");
            }
            if (!linePart.endsWith(" ")) {
                return StringUtil.replace(line, matcher.group(), "<%=" + linePart + " %>");
            }
            line = this.formatWhitespace(line, linePart, true);
        }
        return line;
    }

    private String _formatWhitespace(String fileName, String absolutePath, String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            boolean javaSource = false;
            boolean jsSource = false;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String trimmedLine;
                if (!fileName.endsWith("/jsonws/action.jsp")) {
                    line = this.trimLine(fileName, absolutePath, line);
                }
                if ((trimmedLine = StringUtil.trimLeading(line)).equals("<%") || trimmedLine.equals("<%!")) {
                    javaSource = true;
                } else if (trimmedLine.equals("%>")) {
                    javaSource = false;
                } else if (trimmedLine.equals("<aui:script>") || trimmedLine.startsWith("<aui:script ") || trimmedLine.equals("<script>") || trimmedLine.startsWith("<script ")) {
                    jsSource = true;
                } else if (trimmedLine.equals("</aui:script>") || trimmedLine.equals("</script>")) {
                    jsSource = false;
                }
                if (jsSource && !javaSource) {
                    sb.append(line);
                    sb.append("\n");
                    continue;
                }
                if (!trimmedLine.equals("%>") && line.contains("%>") && !line.contains("--%>") && !line.contains(" %>")) {
                    line = StringUtil.replace(line, "%>", " %>");
                }
                int pos = -1;
                while ((pos = line.indexOf("<%=", pos + 1)) != -1 && pos + 3 != line.length()) {
                    if (line.charAt(pos + 3) == ' ') continue;
                    line = StringUtil.replaceFirst(line, "<%=", "<%= ", pos);
                }
                if (trimmedLine.startsWith("//") || trimmedLine.startsWith("*")) {
                    sb.append(line);
                    sb.append("\n");
                    continue;
                }
                line = this.formatIncorrectSyntax(line, "\t ", "\t", false);
                if ((line = this._formatWhitespace(line, javaSource)).endsWith(">")) {
                    if (line.endsWith("/>")) {
                        if (!trimmedLine.equals("/>") && !line.endsWith(" />")) {
                            line = StringUtil.replaceLast(line, "/>", " />");
                        }
                    } else if (line.endsWith(" >")) {
                        line = StringUtil.replaceLast(line, " >", ">");
                    }
                }
                while (trimmedLine.contains("\t")) {
                    line = StringUtil.replaceLast(line, '\t', " ");
                    trimmedLine = StringUtil.replaceLast(trimmedLine, '\t', " ");
                }
                line = this.formatSelfClosingTags(line);
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }
}

