/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;

public class CamelCaseNameCheck
extends BaseCheck {
    private static final String _MSG_CONSTANT_INVALID_NAME = "constant.invalidName";
    private static final String _MSG_METHOD_INVALID_NAME = "method.invalidName";
    private static final String _MSG_PARAMETER_INVALID_NAME = "parameter.invalidName";
    private static final String _MSG_VARIABLE_INVALID_NAME = "variable.invalidName";

    public int[] getDefaultTokens() {
        return new int[]{9, 21, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (detailAST.getType() == 9 && AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Override")) {
            return;
        }
        DetailAST nameDetailAST = detailAST.findFirstToken(58);
        String name = nameDetailAST.getText();
        this._checkName(detailAST, name, "non", "nonProxyHost", "nonSerializableObjectHandler", "nonSpringServlet");
        this._checkName(detailAST, name, "re", "reCaptcha");
        this._checkName(detailAST, name, "sub", "subSelect");
    }

    private void _checkName(DetailAST detailAST, String name, String s, String ... allowedNames) {
        for (String allowedName : allowedNames) {
            if (name.startsWith(allowedName) || name.startsWith("_" + allowedName) || name.contains(TextFormatter.format(allowedName, 6))) {
                return;
            }
            String allowedNameConstantStyle = StringUtil.toUpperCase(StringUtil.replace(TextFormatter.format(allowedName, 10), '-', '_'));
            if (!name.startsWith(allowedNameConstantStyle) && !name.contains("_" + allowedNameConstantStyle)) continue;
            return;
        }
        if (name.matches(StringBundler.concat("(^_?", s, "|.*", TextFormatter.format(s, 6), ")[A-Z].*"))) {
            if (detailAST.getType() == 9) {
                this.log(detailAST, _MSG_METHOD_INVALID_NAME, new Object[]{s, name});
            } else if (detailAST.getType() == 21) {
                this.log(detailAST, _MSG_PARAMETER_INVALID_NAME, new Object[]{s, name});
            } else {
                this.log(detailAST, _MSG_VARIABLE_INVALID_NAME, new Object[]{s, name});
            }
        } else if (detailAST.getType() == 10 && name.matches(StringBundler.concat("(.*_)?", StringUtil.toUpperCase(s), "_[A-Z].*"))) {
            this.log(detailAST, _MSG_CONSTANT_INVALID_NAME, new Object[]{StringUtil.toUpperCase(s), name});
        }
    }
}

