/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;

public class LFRBuildReadmeCheck
extends BaseFileCheck {
    private static final String _MODULES_README_MARKDOWN_FILE_NAME = "modules/README.markdown";
    private String _modulesReadmeMarkdownContent;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        int pos = fileName.lastIndexOf("/");
        String shortFileName = fileName.substring(pos + 1);
        String readmeMarkdownContent = this._getModulesReadmeMarkdownContent(absolutePath);
        if (Validator.isNotNull(readmeMarkdownContent) && !readmeMarkdownContent.contains(shortFileName)) {
            String message = StringBundler.concat("Please document the \"", shortFileName, "\" marker file in ", "https://github.com/liferay/liferay-portal/blob/", this.getAttributeValue("git.liferay.portal.branch", absolutePath), "/", _MODULES_README_MARKDOWN_FILE_NAME, "#marker-files");
            this.addMessage(fileName, message);
        }
        return content;
    }

    private synchronized String _getModulesReadmeMarkdownContent(String absolutePath) throws IOException {
        if (this._modulesReadmeMarkdownContent != null) {
            return this._modulesReadmeMarkdownContent;
        }
        this._modulesReadmeMarkdownContent = this.getPortalContent(_MODULES_README_MARKDOWN_FILE_NAME, absolutePath);
        return this._modulesReadmeMarkdownContent;
    }
}

