/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJSPTermsCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPMissingTaglibsCheck
extends BaseJSPTermsCheck {
    private static final Pattern _tagPattern = Pattern.compile("<(aui|c|chart|clay|display|liferay(-[\\w-]+)|portlet|soy):");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (absolutePath.contains("/custom_jsps/") || absolutePath.contains("-fragment/")) {
            return content;
        }
        this._checkMissingTaglibs(fileName, content);
        return content;
    }

    private void _checkMissingTaglibs(String fileName, String content) throws IOException {
        Set<String> taglibPrefixes = this._getTaglibPrefixes(content);
        if (taglibPrefixes.isEmpty()) {
            return;
        }
        this.populateContentsMap(fileName, content);
        List<String> dependentfileNames = new ArrayList<String>();
        dependentfileNames.add(fileName);
        Map<String, String> contentsMap = this.getContentsMap();
        dependentfileNames = JSPSourceUtil.addIncludedAndReferencedFileNames(dependentfileNames, new HashSet<String>(), contentsMap, ".*\\.jspf");
        if (fileName.endsWith(".jspf") && dependentfileNames.size() == 1) {
            return;
        }
        for (String dependentfileName : dependentfileNames) {
            String dependenFileContent = contentsMap.get(dependentfileName = StringUtil.replace(dependentfileName, '\\', '/'));
            if (dependenFileContent == null) {
                return;
            }
            Iterator<String> iterator = taglibPrefixes.iterator();
            while (iterator.hasNext()) {
                String prefix = iterator.next();
                if (!dependenFileContent.contains("prefix=\"" + prefix + "\"")) continue;
                iterator.remove();
                if (!taglibPrefixes.isEmpty()) continue;
                return;
            }
        }
        for (String prefix : taglibPrefixes) {
            this.addMessage(fileName, "Missing taglib for tag with prefix '" + prefix + "'");
        }
    }

    private Set<String> _getTaglibPrefixes(String content) {
        HashSet<String> taglibPrefixes = new HashSet<String>();
        Matcher matcher = _tagPattern.matcher(content);
        while (matcher.find()) {
            taglibPrefixes.add(matcher.group(1));
        }
        return taglibPrefixes;
    }
}

