/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.java.parser;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.portal.tools.java.parser.JavaExpression;
import com.liferay.portal.tools.java.parser.JavaNewClassInstantiation;
import com.liferay.portal.tools.java.parser.JavaOperator;
import com.liferay.portal.tools.java.parser.JavaOperatorExpression;
import com.liferay.portal.tools.java.parser.JavaTerm;
import com.liferay.portal.tools.java.parser.JavaType;
import com.liferay.portal.tools.java.parser.JavaTypeCast;
import com.liferay.portal.tools.java.parser.Position;
import com.liferay.portal.tools.java.parser.util.JavaParserUtil;
import java.util.List;
import java.util.Objects;

public abstract class BaseJavaTerm
implements JavaTerm {
    private Position _endPosition;
    private Position _startPosition;
    private String _suffix;

    @Override
    public Position getEndPosition() {
        return this._endPosition;
    }

    @Override
    public Position getStartPosition() {
        return this._startPosition;
    }

    @Override
    public String getSuffix() {
        return this._suffix;
    }

    @Override
    public void setEndPosition(Position endPosition) {
        this._endPosition = endPosition;
    }

    @Override
    public void setStartPosition(Position startPosition) {
        this._startPosition = startPosition;
    }

    @Override
    public void setSuffix(String suffix) {
        this._suffix = suffix;
    }

    public String toString() {
        return this.toString("", "", "", -1);
    }

    @Override
    public String toString(String indent, String prefix, int maxLineLength) {
        return this.toString(indent, prefix, this._suffix, maxLineLength);
    }

    @Override
    public String toString(String indent, String prefix, String suffix, int maxLineLength, boolean forceLineBreak) {
        return this.toString(indent, prefix, suffix, maxLineLength);
    }

    protected String adjustIndent(StringBundler sb, String indent) {
        String s = sb.toString();
        String trimmedString = StringUtil.trim(s);
        if (trimmedString.endsWith("&") || trimmedString.endsWith("|") || trimmedString.endsWith("^")) {
            if (ToolsUtil.getLevel(s) == 0) {
                String leadingWhitespace = this._getLeadingWhitespace(s);
                if (!trimmedString.startsWith("return ")) {
                    return leadingWhitespace;
                }
                return leadingWhitespace + "\t   ";
            }
            int x = -1;
            while (ToolsUtil.getLevel(s.substring((x = s.indexOf(40, x + 1)) + 1)) != 0) {
            }
            int y = s.lastIndexOf(10, x) + 1;
            return this._convertToWhitespace(s.substring(y, x + 1));
        }
        String lastLine = JavaParserUtil.getLastLine(s);
        String trimmedLastLine = StringUtil.trim(lastLine);
        if (trimmedLastLine.startsWith("catch (")) {
            return this._getLeadingWhitespace(lastLine) + "\t\t\t";
        }
        if (trimmedLastLine.startsWith("else if (")) {
            return this._getLeadingWhitespace(lastLine) + "\t\t\t";
        }
        if (trimmedLastLine.startsWith("for (") && !trimmedLastLine.endsWith(";")) {
            return this._getLeadingWhitespace(lastLine) + "\t\t";
        }
        if (trimmedLastLine.startsWith("if (")) {
            return this._getLeadingWhitespace(lastLine) + "\t\t";
        }
        if (trimmedLastLine.startsWith("try (") && !trimmedLastLine.endsWith(";")) {
            return this._getLeadingWhitespace(lastLine) + "\t\t";
        }
        if (trimmedLastLine.startsWith("while (")) {
            return this._getLeadingWhitespace(lastLine) + "\t\t\t";
        }
        return indent;
    }

    protected String append(StringBundler sb, JavaTerm javaTerm, String indent, int maxLineLength) {
        return this.append(sb, javaTerm, indent, maxLineLength, true);
    }

    protected String append(StringBundler sb, JavaTerm javaTerm, String indent, int maxLineLength, boolean newLine) {
        return this.append(sb, javaTerm, indent, "", "", maxLineLength, newLine);
    }

    protected String append(StringBundler sb, JavaTerm javaTerm, String indent, String prefix, String suffix, int maxLineLength) {
        return this.append(sb, javaTerm, indent, prefix, suffix, maxLineLength, true);
    }

    protected String append(StringBundler sb, JavaTerm javaTerm, String indent, String prefix, String suffix, int maxLineLength, boolean newLine) {
        if (this.appendSingleLine(sb, javaTerm, prefix, suffix, maxLineLength)) {
            return indent;
        }
        if (newLine) {
            if (Validator.isNull((sb = this._stripTrailingWhitespace(sb)).toString())) {
                sb.append(javaTerm.toString(StringUtil.replaceFirst(indent, "\t", ""), prefix, suffix, maxLineLength));
            } else {
                this.appendNewLine(sb, javaTerm, indent, prefix, suffix, maxLineLength);
            }
            return "\t" + this.trimTrailingSpaces(this.getIndent(this.getLastLine(sb)));
        }
        return this.appendWithLineBreak(sb, javaTerm, indent, prefix, suffix, maxLineLength);
    }

    protected String append(StringBundler sb, List<? extends JavaTerm> list, String indent, int maxLineLength) {
        return this.append(sb, list, indent, "", "", maxLineLength);
    }

    protected String append(StringBundler sb, List<? extends JavaTerm> list, String indent, String prefix, String suffix, int maxLineLength) {
        return this.append(sb, list, ", ", indent, prefix, suffix, maxLineLength);
    }

    protected String append(StringBundler sb, List<? extends JavaTerm> list, String delimeter, String indent, String prefix, String suffix, int maxLineLength) {
        if (list.isEmpty() && Validator.isNull(prefix) && Validator.isNull(suffix) || this.appendSingleLine(sb, list, delimeter, prefix, suffix, maxLineLength)) {
            return indent;
        }
        String lastLine = this.getLastLine(sb);
        sb = this._stripTrailingWhitespace(sb);
        if (Validator.isNull(StringUtil.trim(lastLine))) {
            this.appendNewLine(sb, list, delimeter, lastLine, prefix, suffix, maxLineLength);
        } else {
            this.appendNewLine(sb, list, delimeter, indent, prefix, suffix, maxLineLength);
        }
        return "\t" + this.getIndent(this.getLastLine(sb));
    }

    protected void appendAssignValue(StringBundler sb, JavaExpression javaExpression, String indent, String suffix, int maxLineLength, boolean forceLineBreak) {
        JavaTypeCast javaTypeCast;
        boolean newLine = false;
        if (javaExpression instanceof JavaOperatorExpression) {
            JavaOperatorExpression javaOperatorExpression = (JavaOperatorExpression)javaExpression;
            JavaOperator javaOperator = javaOperatorExpression.getJavaOperator();
            if (!javaOperator.equals((Object)JavaOperator.LOGICAL_COMPLEMENT_OPERATOR)) {
                newLine = true;
            }
        } else if (javaExpression instanceof JavaTypeCast && (javaTypeCast = (JavaTypeCast)javaExpression).getValueJavaExpression() instanceof JavaOperatorExpression) {
            newLine = true;
        }
        if (!newLine && forceLineBreak) {
            this.appendWithLineBreak(sb, javaExpression, indent, "", suffix, maxLineLength);
        } else {
            this.append(sb, javaExpression, indent, "", suffix, maxLineLength, newLine);
        }
    }

    protected void appendNewLine(StringBundler sb, JavaTerm javaTerm, String indent, int maxLineLength) {
        this.appendNewLine(sb, javaTerm, indent, "", "", maxLineLength);
    }

    protected void appendNewLine(StringBundler sb, JavaTerm javaTerm, String indent, String prefix, String suffix, int maxLineLength) {
        if ((sb = this._stripTrailingWhitespace(sb)).index() > 0) {
            indent = this.adjustIndent(sb, indent);
            sb.append("\n");
        }
        sb.append(indent);
        if (this._appendSingleLine(sb, javaTerm.toString(), prefix, suffix, maxLineLength)) {
            return;
        }
        if (indent.length() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        sb.append(javaTerm.toString(indent, prefix, suffix, maxLineLength));
    }

    protected void appendNewLine(StringBundler sb, List<? extends JavaTerm> list, String indent, int maxLineLength) {
        this.appendNewLine(sb, list, indent, "", "", maxLineLength);
    }

    protected void appendNewLine(StringBundler sb, List<? extends JavaTerm> list, String indent, String prefix, String suffix, int maxLineLength) {
        this.appendNewLine(sb, list, ", ", indent, prefix, suffix, maxLineLength);
    }

    protected void appendNewLine(StringBundler sb, List<? extends JavaTerm> list, String delimeter, String indent, String prefix, String suffix, int maxLineLength) {
        this.appendNewLine(sb, list, delimeter, indent, prefix, suffix, maxLineLength, true);
    }

    protected void appendNewLine(StringBundler sb, List<? extends JavaTerm> list, String delimeter, String indent, String prefix, String suffix, int maxLineLength, boolean breakJavaTerms) {
        if ((sb = this._stripTrailingWhitespace(sb)).index() > 0) {
            indent = this.adjustIndent(sb, indent);
            sb.append("\n");
        }
        sb.append(indent);
        if (list.isEmpty()) {
            sb.append(prefix);
            sb.append(suffix);
            return;
        }
        int i = 0;
        while (true) {
            JavaTerm javaTerm = list.get(i);
            if (i == 1) {
                indent = prefix.equals("try (") ? indent + "\t" : indent + this._convertToWhitespace(prefix);
                prefix = "";
            }
            if (sb.index() == 0 || Objects.equals(sb.stringAt(sb.index() - 1), "\n")) {
                sb.append(indent);
            }
            if (i == list.size() - 1) {
                if (!this.appendSingleLine(sb, javaTerm, prefix, suffix, maxLineLength)) {
                    delimeter = StringUtil.trim(delimeter);
                    if (breakJavaTerms) {
                        this.appendNewLine(sb, javaTerm, indent, prefix, suffix, maxLineLength);
                    } else {
                        this.appendNewLine(sb, javaTerm, indent, prefix, suffix, -1);
                    }
                }
                return;
            }
            if (!this.appendSingleLine(sb, javaTerm, prefix, delimeter, maxLineLength)) {
                sb = this._stripTrailingWhitespace(sb);
                sb.append("\n");
                sb.append(indent);
                if (!this.appendSingleLine(sb, javaTerm, prefix, delimeter, maxLineLength)) {
                    if (breakJavaTerms) {
                        this.appendNewLine(sb, javaTerm, indent, prefix, StringUtil.trimTrailing(delimeter), maxLineLength);
                    } else {
                        this.appendNewLine(sb, javaTerm, indent, prefix, StringUtil.trimTrailing(delimeter), -1);
                    }
                    sb.append("\n");
                }
            }
            ++i;
        }
    }

    protected boolean appendSingleLine(StringBundler sb, JavaTerm javaTerm, int maxLineLength) {
        return this.appendSingleLine(sb, javaTerm, "", "", maxLineLength);
    }

    protected boolean appendSingleLine(StringBundler sb, JavaTerm javaTerm, String prefix, String suffix, int maxLineLength) {
        return this._appendSingleLine(sb, javaTerm.toString(), prefix, suffix, maxLineLength);
    }

    protected boolean appendSingleLine(StringBundler sb, List<? extends JavaTerm> list, int maxLineLength) {
        return this.appendSingleLine(sb, list, "", "", maxLineLength);
    }

    protected boolean appendSingleLine(StringBundler sb, List<? extends JavaTerm> list, String delimeter, int maxLineLength) {
        return this.appendSingleLine(sb, list, delimeter, "", "", maxLineLength);
    }

    protected boolean appendSingleLine(StringBundler sb, List<? extends JavaTerm> list, String prefix, String suffix, int maxLineLength) {
        return this.appendSingleLine(sb, list, ", ", prefix, suffix, maxLineLength);
    }

    protected boolean appendSingleLine(StringBundler sb, List<? extends JavaTerm> list, String delimeter, String prefix, String suffix, int maxLineLength) {
        return this._appendSingleLine(sb, ListUtil.toString(list, "", delimeter), prefix, suffix, maxLineLength);
    }

    protected String appendWithLineBreak(StringBundler sb, JavaTerm javaTerm, String indent, String prefix, String suffix, int maxLineLength) {
        String lastLine = this.getLastLine(sb);
        if (javaTerm instanceof JavaNewClassInstantiation) {
            indent = StringUtil.removeChar(this.getIndent(lastLine), ' ');
            String javaTermContent = javaTerm.toString(indent, StringUtil.replaceFirst(lastLine, indent, "") + prefix, suffix, maxLineLength, true);
            String firstLine = this._getFirstLine(javaTermContent);
            if (firstLine.endsWith(".") || this.getLineLength(firstLine) > maxLineLength || javaTermContent.matches(".*\n\\s*<[\\s\\S]+")) {
                this.appendNewLine(sb, javaTerm, "\t" + indent, prefix, suffix, maxLineLength);
            } else {
                String s = StringUtil.replaceLast(sb.toString(), lastLine, javaTermContent);
                sb.setIndex(0);
                sb.append(s);
            }
            return "\t" + this.getIndent(this.getLastLine(sb));
        }
        indent = StringUtil.replaceFirst(this.adjustIndent(sb, indent), "\t", "");
        if (Validator.isNull(StringUtil.trim(lastLine))) {
            if ((sb = this._stripTrailingWhitespace(sb)).index() > 0) {
                sb.append("\n");
            }
            String s = javaTerm.toString(indent, prefix, suffix, maxLineLength, true);
            sb.append(s);
        } else {
            String javaTermContent = javaTerm.toString(indent, "", suffix, maxLineLength, true);
            javaTermContent = StringUtil.replaceFirst(javaTermContent, indent, prefix);
            String firstLineJavaTermContent = this._getFirstLine(javaTermContent);
            String s = lastLine + firstLineJavaTermContent;
            lastLine = StringUtil.trim(lastLine);
            if (this.getLineLength(s) > maxLineLength) {
                this.appendNewLine(sb, javaTerm, "\t" + indent, prefix, suffix, maxLineLength);
            } else if ((lastLine.endsWith("=") || lastLine.endsWith(")") || lastLine.endsWith("->")) && (firstLineJavaTermContent.endsWith(".") || firstLineJavaTermContent.matches("\\s*\\([^\\)]+\\)?"))) {
                this.appendNewLine(sb, javaTerm, "\t" + indent, prefix, suffix, maxLineLength);
            } else {
                int level = ToolsUtil.getLevel(firstLineJavaTermContent, "<", ">");
                if (level > 0) {
                    this.appendNewLine(sb, javaTerm, "\t" + indent, prefix, suffix, maxLineLength);
                } else {
                    sb.append(javaTermContent);
                }
            }
        }
        indent = "\t" + this.getIndent(this.getLastLine(sb));
        if (javaTerm instanceof JavaType) {
            return this.trimTrailingSpaces(indent);
        }
        return indent;
    }

    protected String getIndent(String s) {
        StringBundler sb = new StringBundler(s.length());
        for (char c : s.toCharArray()) {
            if (!Character.isWhitespace(c)) {
                return sb.toString();
            }
            sb.append(c);
        }
        return s;
    }

    protected String getLastLine(StringBundler sb) {
        return JavaParserUtil.getLastLine(sb.toString());
    }

    protected int getLineLength(String line) {
        int lineLength = 0;
        int tabLength = 4;
        for (char c : line.toCharArray()) {
            if (c == '\t') {
                for (int i = 0; i < tabLength; ++i) {
                    ++lineLength;
                }
                tabLength = 4;
                continue;
            }
            ++lineLength;
            if (--tabLength > 0) continue;
            tabLength = 4;
        }
        return lineLength;
    }

    protected String trimTrailingSpaces(String s) {
        if (s.length() == 0) {
            return s;
        }
        while (s.charAt(s.length() - 1) == ' ') {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    private boolean _appendSingleLine(StringBundler sb, String s, String prefix, String suffix, int maxLineLength) {
        if (s.contains("\n") && maxLineLength != -1) {
            return false;
        }
        int index = sb.index();
        sb.append(prefix);
        sb.append(s);
        sb.append(suffix);
        if (maxLineLength == -1 || this.getLineLength(this.getLastLine(sb)) <= maxLineLength) {
            return true;
        }
        if (suffix.length() > 0) {
            sb.setIndex(sb.index() - 1);
            sb.append(StringUtil.trimTrailing(suffix));
            if (this.getLineLength(this.getLastLine(sb)) <= maxLineLength) {
                return true;
            }
        }
        sb.setIndex(index);
        return false;
    }

    private String _convertToWhitespace(String s) {
        int i;
        StringBundler sb = new StringBundler(s.length());
        for (i = this.getLineLength(s); i >= 4; i -= 4) {
            sb.append("\t");
        }
        for (int j = 0; j < i; ++j) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private String _getFirstLine(String s) {
        int x = s.indexOf("\n");
        if (x != -1) {
            return s.substring(0, x);
        }
        return s;
    }

    private String _getLeadingWhitespace(String s) {
        StringBundler sb = new StringBundler();
        for (char c : s.toCharArray()) {
            if (!Character.isWhitespace(c)) {
                return sb.toString();
            }
            sb.append(c);
        }
        return s;
    }

    private StringBundler _stripTrailingWhitespace(StringBundler sb) {
        while (sb.index() != 0) {
            String trimmedLastAppend = StringUtil.trimTrailing(sb.stringAt(sb.index() - 1));
            if (Validator.isNotNull(trimmedLastAppend)) {
                sb.setStringAt(trimmedLastAppend, sb.index() - 1);
                return sb;
            }
            sb.setIndex(sb.index() - 1);
        }
        return sb;
    }
}

