/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesStylingCheck
extends BaseFileCheck {
    private static final Pattern _sqlPattern = Pattern.compile("\\s(\\(.* ~ \".*\"\\))( (AND|OR) )?\\\\");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = content.replaceAll("(\n\n)( *#+)( [^#\\s])", "$1$2\n$2$3");
        content = content.replaceAll("(\n)( *#+)( [^#\\s].*\n)(?!\\2([ \n]|\\Z))", "$1$2$3$2\n");
        content = content.replaceAll("(\\A|\n)( *[\\w.-]+)(( +=)|(= +))(.*)(\\Z|\n)", "$1$2=$6$7");
        Matcher matcher = _sqlPattern.matcher(content);
        while (matcher.find()) {
            String sqlClause;
            int lineNumber = this.getLineNumber(content, matcher.start());
            String nextSQLClause = this._getSQLClause(SourceUtil.getLine(content, lineNumber + 1));
            if (nextSQLClause == null || (sqlClause = matcher.group(1)).compareTo(nextSQLClause) <= 0) continue;
            content = StringUtil.replaceFirst(content, nextSQLClause, sqlClause, this.getLineStartPos(content, lineNumber + 1));
            return StringUtil.replaceFirst(content, sqlClause, nextSQLClause, this.getLineStartPos(content, lineNumber));
        }
        return content;
    }

    private String _getSQLClause(String line) {
        Matcher matcher = _sqlPattern.matcher(line);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

