/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;

public class JavaIllegalImportsCheck
extends BaseFileCheck {
    private static final String _ENFORCE_JAVA_UTIL_FUNCTION_IMPORTS_KEY = "enforceJavaUtilFunctionImports";
    private static final String _PROXY_EXCLUDES = "proxy.excludes";
    private static final String _SECURE_RANDOM_EXCLUDES = "secure.random.excludes";

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = StringUtil.replace(content, new String[]{"com.liferay.portal.PortalException", "com.liferay.portal.SystemException", "com.liferay.util.LocalizationUtil"}, new String[]{"com.liferay.portal.kernel.exception.PortalException", "com.liferay.portal.kernel.exception.SystemException", "com.liferay.portal.kernel.util.LocalizationUtil"});
        if (this.isAttributeValue(_ENFORCE_JAVA_UTIL_FUNCTION_IMPORTS_KEY, absolutePath)) {
            content = StringUtil.replace(content, new String[]{"com.liferay.portal.kernel.util.Function", "com.liferay.portal.kernel.util.Supplier"}, new String[]{"java.util.function.Function", "java.util.function.Supplier"});
        }
        if (!this.isExcludedPath("run.outside.portal.excludes", absolutePath) && !this.isExcludedPath(_PROXY_EXCLUDES, absolutePath) && content.contains("import java.lang.reflect.Proxy;")) {
            this.addMessage(fileName, "Use ProxyUtil instead of java.lang.reflect.Proxy");
        }
        if (content.contains("import edu.emory.mathcs.backport.java")) {
            this.addMessage(fileName, "Illegal import: edu.emory.mathcs.backport.java");
        }
        if (content.contains("import jodd.util.StringPool")) {
            this.addMessage(fileName, "Illegal import: jodd.util.StringPool");
        }
        if (!this.isExcludedPath("run.outside.portal.excludes", absolutePath) && !this.isExcludedPath(_SECURE_RANDOM_EXCLUDES, absolutePath) && content.contains("java.security.SecureRandom") && !content.contains("javax.crypto.KeyGenerator")) {
            this.addMessage(fileName, "Use SecureRandomUtil or com.liferay.portal.kernel.security.SecureRandom instead of java.security.SecureRandom, see LPS-39058");
        }
        if (content.contains("com.liferay.portal.kernel.util.UnmodifiableList")) {
            this.addMessage(fileName, "Use java.util.Collections.unmodifiableList instead of com.liferay.portal.kernel.util.UnmodifiableList, see LPS-45027");
        }
        if (this.isPortalSource() && absolutePath.contains("/portal-kernel/") && content.contains("import javax.servlet.jsp.")) {
            this.addMessage(fileName, "Never import javax.servlet.jsp.* from portal-kernel, see LPS-47682");
        }
        if (content.contains("org.testng.Assert")) {
            this.addMessage(fileName, "Use org.junit.Assert instead of org.testng.Assert, see LPS-55690");
        }
        if (content.contains(".supportsBatchUpdates()") && !fileName.endsWith("AutoBatchPreparedStatementUtil.java")) {
            this.addMessage(fileName, "Use AutoBatchPreparedStatementUtil instead of DatabaseMetaData.supportsBatchUpdates, see LPS-60473");
        }
        if (!fileName.endsWith("TypeConvertorUtil.java") && content.contains("org.apache.commons.beanutils.PropertyUtils")) {
            this.addMessage(fileName, "Do not use org.apache.commons.beanutils.PropertyUtils, see LPS-62786");
        }
        if (content.contains("Configurable.createConfigurable(") && !fileName.endsWith("ConfigurableUtil.java")) {
            this.addMessage(fileName, "Use ConfigurableUtil.createConfigurable instead of Configurable.createConfigurable, see LPS-64056");
        }
        if (fileName.endsWith("ResourceCommand.java") && content.contains("ServletResponseUtil.sendFile(")) {
            this.addMessage(fileName, "Use PortletResponseUtil.sendFile instead of ServletResponseUtil.sendFile, see LPS-65229");
        }
        if (content.contains("java.util.WeakHashMap")) {
            this.addMessage(fileName, "Do not use java.util.WeakHashMap because it is not thread-safe, see LPS-70963");
        }
        if (!this.isExcludedPath("run.outside.portal.excludes", absolutePath) && content.contains("org.slf4j.Logger")) {
            this.addMessage(fileName, "Use com.liferay.portal.kernel.log.Log instead of org.slf4j.Logger");
        }
        return content;
    }
}

