/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class JavaHelperUtilCheck
extends BaseJavaTermCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        JavaClass javaClass = (JavaClass)javaTerm;
        if (javaClass.isAbstract() || javaClass.isInterface() || javaClass.hasAnnotation("Deprecated") || javaClass.getParentJavaClass() != null) {
            return javaTerm.getContent();
        }
        String className = javaClass.getName();
        boolean helper = false;
        if (className.endsWith("Helper")) {
            helper = true;
            for (String extendedClassName : javaClass.getExtendedClassNames()) {
                if (!extendedClassName.endsWith("Helper")) continue;
                return javaTerm.getContent();
            }
        } else if (!className.endsWith("Util")) {
            return javaTerm.getContent();
        }
        int publicMethodCount = 0;
        List<JavaTerm> childJavaTerms = javaClass.getChildJavaTerms();
        for (JavaTerm childJavaTerm : childJavaTerms) {
            if (childJavaTerm.hasAnnotation("Deprecated") || !(childJavaTerm instanceof JavaMethod) || !childJavaTerm.isProtected() && !childJavaTerm.isPublic()) continue;
            if (!Objects.equals(childJavaTerm.getName(), "main")) {
                ++publicMethodCount;
            }
            if (childJavaTerm.isStatic()) continue;
            if (helper) {
                return javaTerm.getContent();
            }
            if (this._isAllowedNonstaticUtilMethod(childJavaTerm, childJavaTerms)) continue;
            this.addMessage(fileName, "NON-STATIC UTIL");
            return javaTerm.getContent();
        }
        if (helper && publicMethodCount > 0) {
            this.addMessage(fileName, "STATIC HELPER");
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private boolean _isAllowedNonstaticUtilMethod(JavaTerm javaTerm, List<JavaTerm> childJavaTerms) {
        String name = javaTerm.getName();
        if (Objects.equals(javaTerm.getAccessModifier(), "public")) {
            return name.equals("destroy") || name.matches("set[A-Z].*");
        }
        if (javaTerm.hasAnnotation("Activate", "Deactivate", "Reference")) {
            return true;
        }
        for (JavaTerm childJavaTerm : childJavaTerms) {
            String content;
            if (!(childJavaTerm instanceof JavaMethod) || !childJavaTerm.hasAnnotation("Reference") || (content = childJavaTerm.getContent()).contains("unbind = \"-\"")) continue;
            if (content.contains("unbind = \"" + name + "\"")) {
                return true;
            }
            String defaultUnbindMethodName = null;
            String bindMethodName = childJavaTerm.getName();
            defaultUnbindMethodName = bindMethodName.startsWith("add") ? StringUtil.replaceFirst(bindMethodName, "add", "remove") : "un" + bindMethodName;
            if (!name.equals(defaultUnbindMethodName)) continue;
            return true;
        }
        return false;
    }
}

