/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseIfStatementCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPParenthesesCheck
extends BaseIfStatementCheck {
    private static final Pattern _ifStatementPattern = Pattern.compile("[\t\n]((else )?if|while) .*\\) \\{\n");
    private static final Pattern _tagPattern = Pattern.compile("<%= (.+?) %>");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = _ifStatementPattern.matcher(content);
        while (matcher.find()) {
            if (!JSPSourceUtil.isJavaSource(content, matcher.start())) continue;
            this.checkIfClauseParentheses(matcher.group(), fileName, this.getLineNumber(content, matcher.start(1)), true);
        }
        matcher = _tagPattern.matcher(content);
        while (matcher.find()) {
            if (JSPSourceUtil.isJavaSource(content, matcher.start())) continue;
            String ifClause = "if (" + matcher.group(1) + ") {";
            this.checkIfClauseParentheses(ifClause, fileName, this.getLineNumber(content, matcher.start()), true);
        }
        return content;
    }
}

