/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public abstract class BaseJSPTermsCheck
extends BaseFileCheck {
    private List<String> _allFileNames;
    private Map<String, String> _contentsMap;

    @Override
    public void setAllFileNames(List<String> allFileNames) {
        this._allFileNames = allFileNames;
    }

    protected Map<String, String> getContentsMap() {
        return this._contentsMap;
    }

    protected synchronized void populateContentsMap(String fileName, String content) throws IOException {
        if (this._contentsMap != null) {
            return;
        }
        String[] excludes = new String[]{"**/null.jsp", "**/tools/**"};
        List<String> allJSPFileNames = SourceFormatterUtil.filterFileNames(this._allFileNames, excludes, new String[]{"**/*.jsp", "**/*.jspf", "**/*.tag"}, this.getSourceFormatterExcludes(), true);
        this._contentsMap = JSPSourceUtil.getContentsMap(allJSPFileNames);
        if (this._contentsMap.isEmpty()) {
            this._contentsMap.put(fileName, content);
        }
    }

    protected void put(String fileName, String content) {
        this._contentsMap.put(fileName, content);
    }
}

