/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;

public class OSDetector {
    private static Boolean _aix;
    private static Boolean _apple;
    private static String _bitMode;
    private static Boolean _linux;
    private static Boolean _unix;
    private static Boolean _windows;

    @Deprecated
    public static String getBitmode() {
        return OSDetector.getBitMode();
    }

    public static String getBitMode() {
        if (_bitMode != null) {
            return _bitMode;
        }
        _bitMode = System.getProperty("sun.arch.data.model");
        if (Validator.isNull(_bitMode)) {
            _bitMode = System.getProperty("com.ibm.vm.bitmode");
        }
        if (Validator.isNull(_bitMode)) {
            String arch = System.getProperty("os.arch");
            if ((arch = StringUtil.toLowerCase(arch)).equals("amd64") || arch.equals("x86_64")) {
                _bitMode = "64";
            } else if (arch.equals("i386") || arch.equals("i686") || arch.equals("x86")) {
                _bitMode = "32";
            }
        }
        return _bitMode;
    }

    public static boolean isAIX() {
        if (_aix != null) {
            return _aix;
        }
        String osName = System.getProperty("os.name");
        _aix = (osName = StringUtil.toLowerCase(osName)).equals("aix") ? Boolean.TRUE : Boolean.FALSE;
        return _aix;
    }

    public static boolean isApple() {
        if (_apple != null) {
            return _apple;
        }
        String osName = System.getProperty("os.name");
        _apple = (osName = StringUtil.toLowerCase(osName)).contains("darwin") || osName.contains("mac") ? Boolean.TRUE : Boolean.FALSE;
        return _apple;
    }

    public static boolean isLinux() {
        if (_linux != null) {
            return _linux;
        }
        String osName = System.getProperty("os.name");
        _linux = (osName = StringUtil.toLowerCase(osName)).contains("linux") ? Boolean.TRUE : Boolean.FALSE;
        return _linux;
    }

    public static boolean isUnix() {
        if (_unix != null) {
            return _unix;
        }
        _unix = File.pathSeparator.equals(":") ? Boolean.TRUE : Boolean.FALSE;
        return _unix;
    }

    public static boolean isWindows() {
        if (_windows != null) {
            return _windows;
        }
        _windows = File.pathSeparator.equals(";") ? Boolean.TRUE : Boolean.FALSE;
        return _windows;
    }
}

