/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class TestClassCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_ABSTRACT_TEST_CASE_CLASS = "test.case.class.incorrect.abstract";
    private static final String _MSG_INCORRECT_ABSTRACT_TEST_CLASS = "test.class.incorrect.abstract";
    private static final String _MSG_INVALID_BASE_CLASS_NAME = "test.base.class.invalidName";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        String absolutePath = this.getAbsolutePath();
        if (!absolutePath.contains("/test/") && !absolutePath.contains("/testIntegration/")) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null) {
            return;
        }
        DetailAST nameDetailAST = detailAST.findFirstToken(58);
        String name = nameDetailAST.getText();
        if (!name.matches(".*Test(Case)?")) {
            return;
        }
        DetailAST modifiersDetailAST = detailAST.findFirstToken(5);
        if (name.endsWith("TestCase")) {
            if (!modifiersDetailAST.branchContains(40)) {
                this.log(detailAST, _MSG_INCORRECT_ABSTRACT_TEST_CASE_CLASS, new Object[]{name.substring(0, name.length() - 4)});
            } else if (name.contains("Base") && !name.startsWith("Base")) {
                this.log(detailAST, _MSG_INVALID_BASE_CLASS_NAME, new Object[]{name});
            }
        } else if (modifiersDetailAST.branchContains(40)) {
            this.log(detailAST, _MSG_INCORRECT_ABSTRACT_TEST_CLASS, new Object[]{name});
        }
    }
}

