/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.List;

public class MissingEmptyLineCheck
extends BaseCheck {
    private static final String _MSG_MISSING_EMPTY_LINE_AFTER_METHOD_CALL = "empty.line.missing.after.method.call";
    private static final String _MSG_MISSING_EMPTY_LINE_AFTER_VARIABLE_DEFINITION = "empty.line.missing.after.variable.definition";
    private static final String _MSG_MISSING_EMPTY_LINE_AFTER_VARIABLE_REFERENCE = "empty.line.missing.after.variable.reference";
    private static final String _MSG_MISSING_EMPTY_LINE_BEFORE_VARIABLE_ASSIGN = "empty.line.missing.before.variable.assign";
    private static final String _MSG_MISSING_EMPTY_LINE_BEFORE_VARIABLE_USE = "empty.line.missing.before.variable.use";

    public int[] getDefaultTokens() {
        return new int[]{80, 27, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (detailAST.getType() == 27) {
            this._checkMissingEmptyLineAfterMethodCall(detailAST);
            return;
        }
        if (detailAST.getType() == 10) {
            this._checkMissingEmptyLineAfterVariableDef(detailAST, "ThemeDisplay");
            return;
        }
        this._checkMissingEmptyLineBeforeAssign(detailAST);
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST == null || firstChildDetailAST.getType() == 59) {
            return;
        }
        String variableName = this._getVariableName(detailAST);
        if (variableName == null) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        this._checkMissingEmptyLineAfterReferencingVariable(parentDetailAST, variableName, this.getEndLineNumber(detailAST));
        this._checkMissingEmptyLineBetweenAssigningAndUsingVariable(parentDetailAST, variableName, this.getEndLineNumber(detailAST));
    }

    private void _checkMissingEmptyLineAfterMethodCall(DetailAST detailAST) {
        DetailAST firstChildDetailAST;
        int nextExpressionStartLineNumber;
        String variableName = this.getVariableName(detailAST);
        if (variableName == null) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 28) {
            return;
        }
        DetailAST nextSiblingDetailAST = parentDetailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 45) {
            return;
        }
        if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) == null) {
            return;
        }
        int endLineNumber = this.getEndLineNumber(detailAST);
        if (endLineNumber + 1 != (nextExpressionStartLineNumber = this.getStartLineNumber(nextSiblingDetailAST))) {
            return;
        }
        if (nextSiblingDetailAST.getType() == 28 && (firstChildDetailAST = nextSiblingDetailAST.getFirstChild()).getType() == 27 && variableName.equals(this.getVariableName(firstChildDetailAST))) {
            return;
        }
        if (this._containsVariableName(nextSiblingDetailAST, variableName)) {
            this.log(endLineNumber, _MSG_MISSING_EMPTY_LINE_AFTER_METHOD_CALL, new Object[]{endLineNumber});
        }
    }

    private void _checkMissingEmptyLineAfterReferencingVariable(DetailAST detailAST, String variableName, int endLineNumber) {
        String lastAssignedVariableName = null;
        DetailAST previousDetailAST = null;
        boolean referenced = false;
        DetailAST nextSiblingDetailAST = detailAST.getNextSibling();
        while (nextSiblingDetailAST != null && nextSiblingDetailAST.getType() == 45) {
            if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) == null || nextSiblingDetailAST.getType() != 28 && nextSiblingDetailAST.getType() != 10) {
                return;
            }
            if (!this._containsVariableName(nextSiblingDetailAST, variableName)) {
                if (!referenced) {
                    return;
                }
                int nextExpressionStartLineNumber = this.getStartLineNumber(nextSiblingDetailAST);
                if (endLineNumber + 1 != nextExpressionStartLineNumber) {
                    return;
                }
                if (this._containsVariableName(previousDetailAST, lastAssignedVariableName) && this._containsVariableName(nextSiblingDetailAST, lastAssignedVariableName)) {
                    return;
                }
                String methodCallVariableName = this._getMethodCallVariableName(nextSiblingDetailAST);
                if (!this._hasFollowingMethodCallWithVariableName(nextSiblingDetailAST, methodCallVariableName, variableName)) {
                    this.log(nextExpressionStartLineNumber, _MSG_MISSING_EMPTY_LINE_AFTER_VARIABLE_REFERENCE, new Object[]{nextExpressionStartLineNumber, variableName});
                }
                return;
            }
            List<DetailAST> assignDetailASTList = this.getAllChildTokens(nextSiblingDetailAST, false, 80);
            if (assignDetailASTList.size() == 1) {
                lastAssignedVariableName = this._getVariableName(assignDetailASTList.get(0));
            }
            referenced = true;
            endLineNumber = this.getEndLineNumber(nextSiblingDetailAST);
            previousDetailAST = nextSiblingDetailAST;
            nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling();
        }
        return;
    }

    private void _checkMissingEmptyLineAfterVariableDef(DetailAST detailAST, String variableTypeName) {
        String nextLine;
        if (detailAST.findFirstToken(80) == null) {
            return;
        }
        DetailAST identDetailAST = detailAST.findFirstToken(58);
        if (variableTypeName.equals(this.getVariableTypeName(detailAST, identDetailAST.getText(), false)) && Validator.isNotNull(nextLine = StringUtil.trim(this.getLine(this.getEndLineNumber(detailAST)))) && !nextLine.startsWith("}")) {
            this.log(detailAST, _MSG_MISSING_EMPTY_LINE_AFTER_VARIABLE_DEFINITION, new Object[]{variableTypeName});
        }
    }

    private void _checkMissingEmptyLineBeforeAssign(DetailAST assignDetailAST) {
        DetailAST parentDetailAST = assignDetailAST.getParent();
        DetailAST nextSiblingDetailAST = parentDetailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 45) {
            return;
        }
        if (this._hasPrecedingVariableDef(parentDetailAST)) {
            return;
        }
        List<DetailAST> adjacentAssignDetailASTList = this._getAdjacentAssignDetailASTList(assignDetailAST);
        if (adjacentAssignDetailASTList.size() <= 1) {
            return;
        }
        DetailAST lastAssignDetailAST = adjacentAssignDetailASTList.get(adjacentAssignDetailASTList.size() - 1);
        List<DetailAST> identDetailASTList = this._getFollowingStatementsIdentDetailASTList(lastAssignDetailAST.getParent());
        if (this._containsVariableName(identDetailASTList, assignDetailAST)) {
            return;
        }
        DetailAST firstReferencedAssignDetailAST = null;
        for (int i = 1; i < adjacentAssignDetailASTList.size(); ++i) {
            DetailAST curAssignDetailAST = adjacentAssignDetailASTList.get(i);
            if (this._containsVariableName(identDetailASTList, curAssignDetailAST)) {
                if (firstReferencedAssignDetailAST != null) continue;
                firstReferencedAssignDetailAST = curAssignDetailAST;
                continue;
            }
            if (firstReferencedAssignDetailAST == null) continue;
            return;
        }
        if (firstReferencedAssignDetailAST != null) {
            DetailAST nameDetailAST = firstReferencedAssignDetailAST.findFirstToken(58);
            if (nameDetailAST == null) {
                parentDetailAST = firstReferencedAssignDetailAST.getParent();
                nameDetailAST = parentDetailAST.findFirstToken(58);
            }
            this.log(firstReferencedAssignDetailAST, _MSG_MISSING_EMPTY_LINE_BEFORE_VARIABLE_ASSIGN, new Object[]{nameDetailAST.getText()});
        }
    }

    private void _checkMissingEmptyLineBetweenAssigningAndUsingVariable(DetailAST detailAST, String name, int endLineNumber) {
        DetailAST nextSiblingDetailAST = detailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 45) {
            return;
        }
        if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) == null) {
            return;
        }
        int nextExpressionStartLineNumber = this.getStartLineNumber(nextSiblingDetailAST);
        if (endLineNumber + 1 != nextExpressionStartLineNumber) {
            return;
        }
        List<DetailAST> identDetailASTList = this.getAllChildTokens(nextSiblingDetailAST, true, 58);
        boolean nextVariableUsesVariable = false;
        for (DetailAST identDetailAST : identDetailASTList) {
            String identName = identDetailAST.getText();
            if (!identName.equals(name)) continue;
            DetailAST parentDetailAST = identDetailAST.getParent();
            if (parentDetailAST.getType() == 80 && identDetailAST.getPreviousSibling() == null) {
                return;
            }
            nextVariableUsesVariable = true;
        }
        if (nextVariableUsesVariable) {
            this.log(nextExpressionStartLineNumber, _MSG_MISSING_EMPTY_LINE_BEFORE_VARIABLE_USE, new Object[]{name});
        }
    }

    private boolean _containsVariableName(DetailAST detailAST, String variableName) {
        List<DetailAST> identDetailASTList = this.getAllChildTokens(detailAST, true, 58);
        return this._containsVariableName(identDetailASTList, variableName);
    }

    private boolean _containsVariableName(List<DetailAST> identDetailASTList, DetailAST assignDetailAST) {
        String variableName = this._getVariableName(assignDetailAST);
        if (variableName == null) {
            return false;
        }
        return this._containsVariableName(identDetailASTList, variableName);
    }

    private boolean _containsVariableName(List<DetailAST> identDetailASTList, String variableName) {
        if (variableName == null) {
            return false;
        }
        for (DetailAST identDetailAST : identDetailASTList) {
            if (!variableName.equals(identDetailAST.getText())) continue;
            return true;
        }
        return false;
    }

    private List<DetailAST> _getAdjacentAssignDetailASTList(DetailAST assignDetailAST) {
        ArrayList<DetailAST> assignDetailASTList = new ArrayList<DetailAST>();
        assignDetailASTList.add(assignDetailAST);
        DetailAST followingStatementDetailAST = this._getFollowingStatementDetailAST(assignDetailAST.getParent(), false);
        while (followingStatementDetailAST != null) {
            DetailAST followingAssignDetailAST = followingStatementDetailAST.findFirstToken(80);
            if (followingAssignDetailAST == null) {
                return assignDetailASTList;
            }
            assignDetailASTList.add(followingAssignDetailAST);
            followingStatementDetailAST = this._getFollowingStatementDetailAST(followingStatementDetailAST, false);
        }
        return assignDetailASTList;
    }

    private DetailAST _getFollowingStatementDetailAST(DetailAST detailAST, boolean allowDividingEmptyLine) {
        int nextStartLineNumber;
        int endLineNumber = this.getEndLineNumber(detailAST);
        DetailAST nextSiblingDetailAST = detailAST.getNextSibling();
        while (true) {
            if (nextSiblingDetailAST == null) {
                return null;
            }
            nextStartLineNumber = this.getStartLineNumber(nextSiblingDetailAST);
            if (nextStartLineNumber > endLineNumber) break;
            nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling();
        }
        if (allowDividingEmptyLine || nextStartLineNumber == endLineNumber + 1) {
            return nextSiblingDetailAST;
        }
        return null;
    }

    private List<DetailAST> _getFollowingStatementsIdentDetailASTList(DetailAST detailAST) {
        ArrayList<DetailAST> identDetailASTList = new ArrayList<DetailAST>();
        DetailAST followingStatementDetailAST = this._getFollowingStatementDetailAST(detailAST, true);
        while (followingStatementDetailAST != null) {
            identDetailASTList.addAll(this.getAllChildTokens(followingStatementDetailAST, true, 58));
            followingStatementDetailAST = this._getFollowingStatementDetailAST(followingStatementDetailAST, false);
        }
        return identDetailASTList;
    }

    private String _getMethodCallVariableName(DetailAST detailAST) {
        if (detailAST.getType() != 28) {
            return null;
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 27) {
            return null;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() != 59) {
            return null;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() == 58) {
            return firstChildDetailAST.getText();
        }
        return null;
    }

    private String _getVariableName(DetailAST assignDetailAST) {
        DetailAST parentDetailAST = assignDetailAST.getParent();
        if (parentDetailAST.getType() == 28) {
            DetailAST firstChildDetailAST = assignDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() == 58) {
                return firstChildDetailAST.getText();
            }
        } else if (parentDetailAST.getType() == 10) {
            DetailAST nameDetailAST = parentDetailAST.findFirstToken(58);
            return nameDetailAST.getText();
        }
        return null;
    }

    private boolean _hasFollowingMethodCallWithVariableName(DetailAST detailAST, String methodCallVariableName, String variableName) {
        int nextExpressionStartLineNumber;
        if (methodCallVariableName == null) {
            return false;
        }
        DetailAST nextSiblingDetailAST = detailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 45) {
            return false;
        }
        if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) == null) {
            return false;
        }
        int endLineNumber = this.getEndLineNumber(detailAST);
        if (endLineNumber + 1 != (nextExpressionStartLineNumber = this.getStartLineNumber(nextSiblingDetailAST))) {
            return false;
        }
        String nextMethodCallVariableName = this._getMethodCallVariableName(nextSiblingDetailAST);
        if (!methodCallVariableName.equals(nextMethodCallVariableName)) {
            return false;
        }
        if (this._containsVariableName(nextSiblingDetailAST, variableName)) {
            return true;
        }
        return this._hasFollowingMethodCallWithVariableName(nextSiblingDetailAST, methodCallVariableName, variableName);
    }

    private boolean _hasPrecedingVariableDef(DetailAST variableDefinitionDetailAST) {
        DetailAST previousSiblingDetailAST = variableDefinitionDetailAST.getPreviousSibling();
        if (previousSiblingDetailAST == null || previousSiblingDetailAST.getType() != 45) {
            return false;
        }
        if ((previousSiblingDetailAST = previousSiblingDetailAST.getPreviousSibling()).getType() != 10) {
            return false;
        }
        return this.getEndLineNumber(previousSiblingDetailAST) + 1 == this.getStartLineNumber(variableDefinitionDetailAST);
    }
}

