/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseChainedMethodCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseBuilderCheck
extends BaseChainedMethodCheck {
    private static final String _CHECK_INLINE = "checkInline";
    private static final String _MSG_INCLUDE_BUILDER = "builder.include";
    private static final String _MSG_INCORRECT_NULL_VALUE = "null.value.incorrect";
    private static final String _MSG_INLINE_BUILDER = "builder.inline";
    private static final String _MSG_USE_BUILDER = "builder.use";
    private static final String _MSG_USE_BUILDER_INSTEAD = "builder.use.instead";
    private static final String _RUN_OUTSIDE_PORTAL_EXCLUDES = "run.outside.portal.excludes";

    public int[] getDefaultTokens() {
        return new int[]{80, 11, 27};
    }

    protected abstract boolean allowNullValues();

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (this.isExcludedPath(_RUN_OUTSIDE_PORTAL_EXCLUDES)) {
            return;
        }
        if (detailAST.getType() == 11) {
            this._checkAnonymousClass(detailAST);
            return;
        }
        if (detailAST.getType() == 27) {
            this._checkBuilder(detailAST);
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 28 && parentDetailAST.getType() != 10) {
            return;
        }
        DetailAST nextSiblingDetailAST = parentDetailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 45) {
            return;
        }
        String variableName = this.getVariableName(detailAST, parentDetailAST);
        if (variableName == null) {
            return;
        }
        this._checkNewInstance(detailAST, variableName, parentDetailAST, nextSiblingDetailAST);
    }

    protected abstract List<BuilderInformation> getBuilderInformationList();

    protected abstract boolean isSupportsNestedMethodCalls();

    private void _checkAnonymousClass(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 6) {
            return;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 136) {
            return;
        }
        DetailAST identDetailAST = parentDetailAST.findFirstToken(58);
        if (identDetailAST == null) {
            return;
        }
        String className = identDetailAST.getText();
        List<String> typeNames = this._getTypeNames();
        if (!typeNames.contains(className)) {
            return;
        }
        List<DetailAST> childDetailASTList = this.getAllChildTokens(detailAST, true, -1);
        for (DetailAST childDetailAST : childDetailASTList) {
            if (this.getHiddenBefore(childDetailAST) == null) continue;
            return;
        }
        BuilderInformation builderInformation = this._findBuilderInformationByClassName(className);
        if (builderInformation == null) {
            return;
        }
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            DetailAST firstChildDetailAST;
            parentDetailAST = methodCallDetailAST.getParent();
            if (parentDetailAST.getType() != 28 || (parentDetailAST = parentDetailAST.getParent()).getType() != 7 || (firstChildDetailAST = methodCallDetailAST.getFirstChild()).getType() != 58) continue;
            if (this.isSupportsNestedMethodCalls() ? (parentDetailAST = this.getParentWithTokenType(methodCallDetailAST, 175, 181, 91, 84)) != null && detailAST.getLineNo() <= parentDetailAST.getLineNo() : !this.equals(parentDetailAST.getParent(), detailAST)) {
                return;
            }
            if (!ArrayUtil.contains(builderInformation.getMethodNames(), firstChildDetailAST.getText())) {
                return;
            }
            if (this.allowNullValues()) continue;
            DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
            for (DetailAST childDetailAST = elistDetailAST.getFirstChild(); childDetailAST != null; childDetailAST = childDetailAST.getNextSibling()) {
                if (!this._isNullValueExpression(childDetailAST)) continue;
                return;
            }
        }
        this.log(detailAST, _MSG_USE_BUILDER_INSTEAD, new Object[]{builderInformation.getBuilderClassName(), className});
    }

    private void _checkBuilder(DetailAST methodCallDetailAST) {
        DetailAST greatGrandParentDetailAST;
        DetailAST firstChildDetailAST = methodCallDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 59) {
            return;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() != 58) {
            return;
        }
        String builderClassName = firstChildDetailAST.getText();
        BuilderInformation builderInformation = this._findBuilderInformationByBuilderClassName(builderClassName);
        if (builderInformation == null) {
            return;
        }
        List<DetailAST> methodVariableDetailASTList = this._getMethodVariableDetailASTList(methodCallDetailAST);
        if (!this.allowNullValues()) {
            this._checkNullValues(methodVariableDetailASTList, builderClassName);
        }
        DetailAST parentDetailAST = methodCallDetailAST.getParent();
        while (parentDetailAST.getType() == 59 || parentDetailAST.getType() == 28 || parentDetailAST.getType() == 27) {
            parentDetailAST = parentDetailAST.getParent();
        }
        if (parentDetailAST.getType() == 88) {
            this._checkInline(parentDetailAST, methodVariableDetailASTList, builderClassName);
        }
        if (parentDetailAST.getType() != 80) {
            return;
        }
        DetailAST assignDetailAST = parentDetailAST;
        DetailAST grandParentDetailAST = (parentDetailAST = assignDetailAST.getParent()).getParent();
        if (grandParentDetailAST.getType() == 6 && (greatGrandParentDetailAST = grandParentDetailAST.getParent()).getType() == 14) {
            return;
        }
        this._checkInline(parentDetailAST, methodVariableDetailASTList, builderClassName);
        firstChildDetailAST = assignDetailAST.getFirstChild();
        DetailAST assignValueDetailAST = null;
        assignValueDetailAST = parentDetailAST.getType() == 28 ? firstChildDetailAST.getNextSibling() : firstChildDetailAST.getFirstChild();
        if (assignValueDetailAST == null || assignValueDetailAST.getType() != 27) {
            return;
        }
        List<String> variableNames = this._getVariableNames(parentDetailAST, "get.*");
        String variableName = this.getVariableName(assignDetailAST, parentDetailAST);
        variableNames.add(variableName);
        String[] builderMethodNames = builderInformation.getMethodNames();
        DetailAST nextSiblingDetailAST = parentDetailAST.getNextSibling();
        while (nextSiblingDetailAST != null) {
            FullIdent fullIdent = this.getMethodCallFullIdent(nextSiblingDetailAST, variableName, builderMethodNames);
            if (fullIdent != null) {
                this.log(assignDetailAST, _MSG_INCLUDE_BUILDER, new Object[]{fullIdent.getText(), fullIdent.getLineNo(), builderClassName, assignDetailAST.getLineNo()});
                return;
            }
            for (String curVariableName : variableNames) {
                if (!this.containsVariableName(nextSiblingDetailAST, curVariableName)) continue;
                return;
            }
            nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling();
        }
        return;
    }

    private void _checkInline(DetailAST parentDetailAST, List<DetailAST> methodVariableDetailASTList, String builderClassName) {
        if (!this.isAttributeValue(_CHECK_INLINE)) {
            return;
        }
        ArrayList<String> followingVariableNames = new ArrayList<String>();
        for (DetailAST nextSiblingDetailAST = parentDetailAST.getNextSibling(); nextSiblingDetailAST != null; nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) {
            followingVariableNames.addAll(this._getVariableNames(nextSiblingDetailAST));
        }
        ArrayList<String> inBetweenVariableNames = new ArrayList<String>();
        DetailAST previousSiblingDetailAST = parentDetailAST.getPreviousSibling();
        while (previousSiblingDetailAST != null) {
            if (previousSiblingDetailAST.getType() != 10) {
                followingVariableNames.addAll(this._getVariableNames(previousSiblingDetailAST));
                inBetweenVariableNames.addAll(this._getVariableNames(previousSiblingDetailAST, "get.*"));
                previousSiblingDetailAST = previousSiblingDetailAST.getPreviousSibling();
                continue;
            }
            DetailAST identDetailAST = previousSiblingDetailAST.findFirstToken(58);
            String name = identDetailAST.getText();
            DetailAST matchingMethodVariableDetailAST = this._getExprDetailAST(methodVariableDetailASTList, name);
            if (!followingVariableNames.contains(name) && matchingMethodVariableDetailAST != null && !this._referencesNonfinalVariable(previousSiblingDetailAST)) {
                List<String> variableNames = this._getVariableNames(previousSiblingDetailAST);
                boolean contains = false;
                for (String variableName : variableNames) {
                    if (!inBetweenVariableNames.contains(variableName)) continue;
                    contains = true;
                    break;
                }
                if (!contains) {
                    this.log(identDetailAST, _MSG_INLINE_BUILDER, new Object[]{name, identDetailAST.getLineNo(), builderClassName, parentDetailAST.getLineNo()});
                }
            }
            followingVariableNames.addAll(this._getVariableNames(previousSiblingDetailAST));
            inBetweenVariableNames.addAll(this._getVariableNames(previousSiblingDetailAST, "get.*"));
            previousSiblingDetailAST = previousSiblingDetailAST.getPreviousSibling();
        }
        return;
    }

    private void _checkNewInstance(DetailAST detailAST, String variableName, DetailAST parentDetailAST, DetailAST nextSiblingDetailAST) {
        String newInstanceTypeName = this._getNewInstanceTypeName(detailAST, parentDetailAST);
        if (newInstanceTypeName == null) {
            return;
        }
        List<String> typeNames = this._getTypeNames();
        if (!typeNames.contains(newInstanceTypeName)) {
            return;
        }
        BuilderInformation builderInformation = this._findBuilderInformationByClassName(newInstanceTypeName);
        if (builderInformation == null) {
            return;
        }
        do {
            if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) == null) {
                return;
            }
            FullIdent fullIdent = this.getMethodCallFullIdent(nextSiblingDetailAST, variableName, builderInformation.getMethodNames());
            if (fullIdent == null) continue;
            DetailAST methodCallDetailAST = nextSiblingDetailAST.findFirstToken(27);
            DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
            DetailAST childDetailAST = elistDetailAST.getFirstChild();
            while (true) {
                if (childDetailAST == null) {
                    this.log(detailAST, _MSG_USE_BUILDER, new Object[]{builderInformation.getBuilderClassName(), detailAST.getLineNo(), fullIdent.getLineNo()});
                    return;
                }
                if (!this.allowNullValues() && this._isNullValueExpression(childDetailAST)) {
                    return;
                }
                childDetailAST = childDetailAST.getNextSibling();
            }
        } while (!this.containsVariableName(nextSiblingDetailAST, variableName));
    }

    private void _checkNullValues(List<DetailAST> methodVariableDetailASTList, String builderClassName) {
        for (DetailAST methodVariableDetailAST : methodVariableDetailASTList) {
            if (!this._isNullValueExpression(methodVariableDetailAST)) continue;
            this.log(methodVariableDetailAST, _MSG_INCORRECT_NULL_VALUE, new Object[]{builderClassName});
        }
    }

    private BuilderInformation _findBuilderInformationByBuilderClassName(String builderClassName) {
        for (BuilderInformation builderInformation : this.getBuilderInformationList()) {
            if (!builderClassName.equals(builderInformation.getBuilderClassName())) continue;
            return builderInformation;
        }
        return null;
    }

    private BuilderInformation _findBuilderInformationByClassName(String className) {
        for (BuilderInformation builderInformation : this.getBuilderInformationList()) {
            if (!className.equals(builderInformation.getClassName())) continue;
            return builderInformation;
        }
        return null;
    }

    private DetailAST _getExprDetailAST(List<DetailAST> exprDetailASTList, String name) {
        DetailAST exprDetailAST = null;
        for (DetailAST curExprDetailAST : exprDetailASTList) {
            List<String> variableNames = this._getVariableNames(curExprDetailAST);
            if (!variableNames.contains(name)) continue;
            if (exprDetailAST != null) {
                return null;
            }
            exprDetailAST = curExprDetailAST;
        }
        return exprDetailAST;
    }

    private List<DetailAST> _getMethodVariableDetailASTList(DetailAST methodCallDetailAST) {
        ArrayList<DetailAST> exprDetailASTList = new ArrayList<DetailAST>();
        while (true) {
            DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
            for (DetailAST childDetailAST = elistDetailAST.getFirstChild(); childDetailAST != null; childDetailAST = childDetailAST.getNextSibling()) {
                if (childDetailAST.getType() == 74) continue;
                exprDetailASTList.add(childDetailAST);
            }
            DetailAST parentDetailAST = methodCallDetailAST.getParent();
            if (parentDetailAST.getType() != 59) {
                return exprDetailASTList;
            }
            methodCallDetailAST = parentDetailAST.getParent();
        }
    }

    private String _getNewInstanceTypeName(DetailAST assignDetailAST, DetailAST parentDetailAST) {
        DetailAST firstChildDetailAST = assignDetailAST.getFirstChild();
        DetailAST assignValueDetailAST = null;
        assignValueDetailAST = parentDetailAST.getType() == 28 ? firstChildDetailAST.getNextSibling() : firstChildDetailAST.getFirstChild();
        if (assignValueDetailAST == null || assignValueDetailAST.getType() != 136) {
            return null;
        }
        DetailAST identDetailAST = assignValueDetailAST.findFirstToken(58);
        if (identDetailAST == null) {
            return null;
        }
        DetailAST elistDetailAST = assignValueDetailAST.findFirstToken(34);
        if (elistDetailAST == null || elistDetailAST.getFirstChild() != null) {
            return null;
        }
        return identDetailAST.getText();
    }

    private List<String> _getTypeNames() {
        ArrayList<String> typeNames = new ArrayList<String>();
        for (BuilderInformation builderInformation : this.getBuilderInformationList()) {
            typeNames.add(builderInformation.getClassName());
        }
        return typeNames;
    }

    private List<String> _getVariableNames(DetailAST detailAST) {
        return this._getVariableNames(detailAST, null);
    }

    private List<String> _getVariableNames(DetailAST detailAST, String excludeRegex) {
        ArrayList<String> variableNames = new ArrayList<String>();
        List<DetailAST> identDetailASTList = this.getAllChildTokens(detailAST, true, 58);
        for (DetailAST identDetailAST : identDetailASTList) {
            DetailAST nextSiblingDetailAST;
            String variableName = identDetailAST.getText();
            if (!variableName.matches("[a-z_].*")) continue;
            DetailAST parentDetailAST = identDetailAST.getParent();
            if (parentDetailAST.getType() == 80 || parentDetailAST.getType() == 28 || parentDetailAST.getType() == 23 || ArrayUtil.contains(ARITHMETIC_OPERATOR_TOKEN_TYPES, parentDetailAST.getType()) || ArrayUtil.contains(CONDITIONAL_OPERATOR_TOKEN_TYPES, parentDetailAST.getType()) || ArrayUtil.contains(RELATIONAL_OPERATOR_TOKEN_TYPES, parentDetailAST.getType()) || ArrayUtil.contains(UNARY_OPERATOR_TOKEN_TYPES, parentDetailAST.getType())) {
                variableNames.add(variableName);
                continue;
            }
            if (parentDetailAST.getType() != 59 || (nextSiblingDetailAST = identDetailAST.getNextSibling()) == null) continue;
            if (nextSiblingDetailAST.getType() != 58 || excludeRegex == null) {
                variableNames.add(variableName);
                continue;
            }
            String s = nextSiblingDetailAST.getText();
            if (s.matches(excludeRegex)) continue;
            variableNames.add(variableName);
        }
        return variableNames;
    }

    private boolean _isNullValueExpression(DetailAST detailAST) {
        DetailAST lastChildDetailAST;
        if (detailAST.getType() != 28) {
            return false;
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 135) {
            return true;
        }
        return firstChildDetailAST.getType() == 23 && (lastChildDetailAST = firstChildDetailAST.getLastChild()).getType() == 135;
    }

    private boolean _referencesNonfinalVariable(DetailAST detailAST) {
        List<String> variableNames = this._getVariableNames(detailAST);
        for (String variableName : variableNames) {
            DetailAST variableTypeDetailAST = this.getVariableTypeDetailAST(detailAST, variableName);
            if (variableTypeDetailAST == null) {
                return true;
            }
            DetailAST variableDefinitionDetailAST = variableTypeDetailAST.getParent();
            DetailAST parentDetailAST = variableDefinitionDetailAST.getParent();
            if (parentDetailAST.getType() == 6) {
                DetailAST modifiersDetailAST = variableDefinitionDetailAST.findFirstToken(5);
                if (modifiersDetailAST != null && modifiersDetailAST.branchContains(39)) continue;
                return true;
            }
            List<DetailAST> variableCallerDetailASTList = this.getVariableCallerDetailASTList(variableDefinitionDetailAST, variableName);
            for (DetailAST variableCallerDetailAST : variableCallerDetailASTList) {
                parentDetailAST = variableCallerDetailAST.getParent();
                if (parentDetailAST.getType() != 80 && parentDetailAST.getType() != 106 && parentDetailAST.getType() != 108 && parentDetailAST.getType() != 107 && parentDetailAST.getType() != 130 && parentDetailAST.getType() != 101 && parentDetailAST.getType() != 129 && parentDetailAST.getType() != 99 && parentDetailAST.getType() != 102 && parentDetailAST.getType() != 98 && parentDetailAST.getType() != 26 && parentDetailAST.getType() != 25 && parentDetailAST.getType() != 105 && parentDetailAST.getType() != 103 && parentDetailAST.getType() != 100) continue;
                return true;
            }
        }
        return false;
    }

    protected static class BuilderInformation {
        private final String _builderClassName;
        private final String _className;
        private final String[] _methodNames;

        public BuilderInformation(String className, String builderClassName, String ... methodNames) {
            this._className = className;
            this._builderClassName = builderClassName;
            this._methodNames = methodNames;
        }

        public String getBuilderClassName() {
            return this._builderClassName;
        }

        public String getClassName() {
            return this._className;
        }

        public String[] getMethodNames() {
            return this._methodNames;
        }
    }
}

