/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.JavaParser;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class PropertiesVerifyPropertiesCheck
extends BaseFileCheck {
    private static final String _VERIFY_PROPERTIES_FILE_NAME = "portal-impl/src/com/liferay/portal/verify/VerifyProperties.java";
    private List<LegacyProperty> _legacyProperties;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (absolutePath.contains("/modules/")) {
            return content;
        }
        PropertyType propertyType = null;
        if (absolutePath.matches(".*/portal([-\\w]+)?\\.properties")) {
            propertyType = PropertyType.PORTAL;
        } else if (absolutePath.matches(".*/system([-\\w]+)?\\.properties")) {
            propertyType = PropertyType.SYSTEM;
        } else {
            return content;
        }
        Properties properties = new Properties();
        properties.load(new StringReader(content));
        List<LegacyProperty> legacyProperties = this._getLegacyProperties(absolutePath);
        for (LegacyProperty legacyProperty : legacyProperties) {
            if (!properties.containsKey(legacyProperty.getName()) || !propertyType.equals((Object)legacyProperty.getPropertyType())) continue;
            StringBundler sb = new StringBundler(10);
            if (propertyType.equals((Object)PropertyType.PORTAL)) {
                sb.append("Portal ");
            } else {
                sb.append("System ");
            }
            sb.append("property '");
            sb.append(legacyProperty.getName());
            ActionType actionType = legacyProperty.getActionType();
            if (actionType.equals((Object)ActionType.MIGRATED)) {
                sb.append("' was migrated to ");
                if (propertyType.equals((Object)PropertyType.PORTAL)) {
                    sb.append("'system.properties'");
                } else {
                    sb.append("'portal.properties'");
                }
            } else if (actionType.equals((Object)ActionType.MODULARIZED)) {
                sb.append("' was modularized");
            } else if (actionType.equals((Object)ActionType.OBSOLETE)) {
                sb.append("' is obsolete");
            } else {
                sb.append("' was renamed");
            }
            sb.append(". See '");
            sb.append(StringUtil.removeSubstring(_VERIFY_PROPERTIES_FILE_NAME, ".java"));
            sb.append("#");
            sb.append(legacyProperty.getVariableName());
            sb.append("'.");
            this.addMessage(fileName, sb.toString());
        }
        return content;
    }

    private static List<String> _getLines(String s) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(s));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    private void _addLegacyProperties(DetailAST variableDefinitionDetailAST) {
        DetailAST assignDetailAST = variableDefinitionDetailAST.findFirstToken(80);
        if (assignDetailAST == null) {
            return;
        }
        DetailAST identDetailAST = variableDefinitionDetailAST.findFirstToken(58);
        String variableName = identDetailAST.getText();
        if (variableName.equals("_MIGRATED_PORTAL_KEYS")) {
            this._addLegacyProperties(PropertyType.PORTAL, ActionType.MIGRATED, assignDetailAST, variableName);
        } else if (variableName.equals("_MIGRATED_SYSTEM_KEYS")) {
            this._addLegacyProperties(PropertyType.SYSTEM, ActionType.MIGRATED, assignDetailAST, variableName);
        } else if (variableName.equals("_MODULARIZED_PORTAL_KEYS")) {
            this._addLegacyProperties(PropertyType.PORTAL, ActionType.MODULARIZED, assignDetailAST, variableName);
        } else if (variableName.equals("_MODULARIZED_SYSTEM_KEYS")) {
            this._addLegacyProperties(PropertyType.SYSTEM, ActionType.MODULARIZED, assignDetailAST, variableName);
        } else if (variableName.equals("_OBSOLETE_PORTAL_KEYS")) {
            this._addLegacyProperties(PropertyType.PORTAL, ActionType.OBSOLETE, assignDetailAST, variableName);
        } else if (variableName.equals("_OBSOLETE_SYSTEM_KEYS")) {
            this._addLegacyProperties(PropertyType.SYSTEM, ActionType.OBSOLETE, assignDetailAST, variableName);
        } else if (variableName.equals("_RENAMED_PORTAL_KEYS")) {
            this._addLegacyProperties(PropertyType.PORTAL, ActionType.RENAMED, assignDetailAST, variableName);
        } else if (variableName.equals("_RENAMED_SYSTEM_KEYS")) {
            this._addLegacyProperties(PropertyType.SYSTEM, ActionType.RENAMED, assignDetailAST, variableName);
        }
    }

    private void _addLegacyProperties(PropertyType propertyType, ActionType actionType, DetailAST assignDetailAST, String variableName) {
        DetailAST firstChildDetailAST = assignDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 29) {
            return;
        }
        List<DetailAST> arrayValueDetailASTList = this._getArrayValueDetailASTList(firstChildDetailAST);
        for (DetailAST arrayValueDetailAST : arrayValueDetailASTList) {
            if (arrayValueDetailAST.getType() == 29) {
                this._addLegacyProperty(propertyType, actionType, variableName, this._getArrayValueDetailASTList(arrayValueDetailAST));
                continue;
            }
            this._addLegacyProperty(propertyType, actionType, variableName, Arrays.asList(arrayValueDetailAST));
        }
    }

    private void _addLegacyProperty(PropertyType propertyType, ActionType actionType, String variableName, List<DetailAST> detailASTList) {
        if (detailASTList.isEmpty()) {
            return;
        }
        String name = this._getStringValue(detailASTList.get(0));
        if (name != null) {
            this._legacyProperties.add(new LegacyProperty(name, propertyType, actionType, variableName));
        }
    }

    private List<DetailAST> _getArrayValueDetailASTList(DetailAST arrayInitDetailAST) {
        ArrayList<DetailAST> arrayValueDetailASTList = new ArrayList<DetailAST>();
        DetailAST childDetailAST = arrayInitDetailAST.getFirstChild();
        while (childDetailAST != null) {
            if (childDetailAST.getType() != 74 && childDetailAST.getType() != 73) {
                arrayValueDetailASTList.add(childDetailAST);
            }
            childDetailAST = childDetailAST.getNextSibling();
        }
        return arrayValueDetailASTList;
    }

    private synchronized List<LegacyProperty> _getLegacyProperties(String absolutePath) throws Exception {
        if (this._legacyProperties != null) {
            return this._legacyProperties;
        }
        this._legacyProperties = new ArrayList<LegacyProperty>();
        String verifyPropertiesContent = this.getPortalContent(_VERIFY_PROPERTIES_FILE_NAME, absolutePath);
        List<String> lines = PropertiesVerifyPropertiesCheck._getLines(verifyPropertiesContent);
        FileText fileText = new FileText(new File(_VERIFY_PROPERTIES_FILE_NAME), lines);
        FileContents fileContents = new FileContents(fileText);
        DetailAST rootDetailAST = JavaParser.parse((FileContents)fileContents);
        DetailAST nextSiblingDetailAST = rootDetailAST.getNextSibling();
        while (nextSiblingDetailAST.getType() != 14) {
            nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling();
        }
        List<DetailAST> variableDefinitionDetailASTList = DetailASTUtil.getAllChildTokens(nextSiblingDetailAST, true, 10);
        for (DetailAST variableDefinitionDetailAST : variableDefinitionDetailASTList) {
            this._addLegacyProperties(variableDefinitionDetailAST);
        }
        return this._legacyProperties;
    }

    private String _getStringValue(DetailAST detailAST) {
        if (detailAST.getType() == 28) {
            detailAST = detailAST.getFirstChild();
        }
        if (detailAST.getType() == 139) {
            String text = detailAST.getText();
            return text.substring(1, text.length() - 1);
        }
        if (detailAST.getType() == 125) {
            String left = this._getStringValue(detailAST.getFirstChild());
            String right = this._getStringValue(detailAST.getLastChild());
            if (left != null && right != null) {
                return left + right;
            }
        }
        return null;
    }

    private static enum PropertyType {
        PORTAL,
        SYSTEM;

    }

    private class LegacyProperty {
        private final ActionType _actionType;
        private final String _name;
        private final PropertyType _propertyType;
        private final String _variableName;

        public LegacyProperty(String name, PropertyType propertyType, ActionType actionType, String variableName) {
            this._name = name;
            this._propertyType = propertyType;
            this._actionType = actionType;
            this._variableName = variableName;
        }

        public ActionType getActionType() {
            return this._actionType;
        }

        public String getName() {
            return this._name;
        }

        public PropertyType getPropertyType() {
            return this._propertyType;
        }

        public String getVariableName() {
            return this._variableName;
        }
    }

    private static enum ActionType {
        MIGRATED,
        MODULARIZED,
        OBSOLETE,
        RENAMED;

    }
}

