/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.io.IOException;
import java.util.regex.Pattern;

public class PoshiStylingCheck
extends BaseFileCheck {
    private static final Pattern _multiLineCommentsPattern = Pattern.compile("[ \t]/\\*.*?\\*/", 32);
    private static final Pattern _multiLineStringPattern = Pattern.compile("'''.*?'''", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        this._checkLineBreak(fileName, content);
        return content;
    }

    private void _checkLineBreak(String fileName, String content) {
        int x = -1;
        int[] multiLineCommentsPositions = SourceUtil.getMultiLinePositions(content, _multiLineCommentsPattern);
        int[] multiLineStringPositions = SourceUtil.getMultiLinePositions(content, _multiLineStringPattern);
        while ((x = content.indexOf(59, x + 1)) != -1) {
            int lineNumber = this.getLineNumber(content, x);
            String line = this.getLine(content, lineNumber);
            if (content.charAt(x + 1) == '\n' || ToolsUtil.isInsideQuotes(content, x) || SourceUtil.isInsideMultiLines(lineNumber, multiLineCommentsPositions) || SourceUtil.isInsideMultiLines(lineNumber, multiLineStringPositions) || StringUtil.startsWith(line.trim(), "//")) continue;
            this.addMessage(fileName, "There should be a line break after ';'", this.getLineNumber(content, x));
        }
        return;
    }
}

