/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class JavaSourceFormatterDocumentationCheck
extends BaseJavaTermCheck {
    private static final String _DOCUMENTATION_DIR_LOCATION = "modules/util/source-formatter/src/main/resources/documentation/checks/";

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        if (javaTerm.isAbstract()) {
            return javaTerm.getContent();
        }
        JavaClass javaClass = (JavaClass)javaTerm;
        String packageName = javaClass.getPackageName();
        if (packageName != null && (packageName.equals("com.liferay.source.formatter.checkstyle.checks") || packageName.equals("com.liferay.source.formatter.checks") && fileContent.contains("\taddMessage("))) {
            this._checkMissingDocumentation(fileName, javaClass);
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private void _checkMissingDocumentation(String fileName, JavaClass javaClass) {
        if (this._hasDocumentationFile(javaClass.getName())) {
            return;
        }
        List<String> extendedClassNames = javaClass.getExtendedClassNames();
        if (extendedClassNames.isEmpty()) {
            return;
        }
        String extendedClassName = extendedClassNames.get(0);
        if (!(this._hasDocumentationFile(extendedClassName) || extendedClassName.startsWith("Base") && this._hasDocumentationFile(extendedClassName.substring(4)))) {
            this.addMessage(fileName, "Missing documentation file");
        }
    }

    private boolean _hasDocumentationFile(String checkName) {
        String markdownFileName = SourceFormatterUtil.getMarkdownFileName(checkName);
        File markdownFile = this.getFile(_DOCUMENTATION_DIR_LOCATION + markdownFileName, 7);
        return markdownFile != null;
    }
}

