/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class OperatorOperandCheck
extends BaseCheck {
    private static final String _MSG_IMPROVE_READABILITY = "readability.improve";

    public int[] getDefaultTokens() {
        return ArrayUtil.append(ARITHMETIC_OPERATOR_TOKEN_TYPES, RELATIONAL_OPERATOR_TOKEN_TYPES);
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (this._isInsideGlobalVariableDefinition(detailAST)) {
            return;
        }
        this._checkOperand(detailAST, detailAST.getFirstChild(), "left");
        if (ArrayUtil.contains(ARITHMETIC_OPERATOR_TOKEN_TYPES, detailAST.getType())) {
            this._checkOperand(detailAST, detailAST.getLastChild(), "right");
        }
    }

    private void _checkOperand(DetailAST operatorDetailAST, DetailAST detailAST, String side) {
        if (detailAST == null || detailAST.getType() != 27) {
            return;
        }
        if (this.isAtLineEnd(detailAST, this.getLine(detailAST.getLineNo() - 1))) {
            this.log(detailAST, _MSG_IMPROVE_READABILITY, new Object[]{side, operatorDetailAST.getText()});
            return;
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 59 && this.isAtLineEnd(firstChildDetailAST, this.getLine(firstChildDetailAST.getLineNo() - 1))) {
            this.log(firstChildDetailAST, _MSG_IMPROVE_READABILITY, new Object[]{side, operatorDetailAST.getText()});
        }
    }

    private boolean _isInsideGlobalVariableDefinition(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        while (parentDetailAST != null) {
            if (parentDetailAST.getType() == 14 || parentDetailAST.getType() == 154 || parentDetailAST.getType() == 15) {
                return true;
            }
            if (parentDetailAST.getType() == 8 || parentDetailAST.getType() == 9) {
                return false;
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return false;
    }
}

