/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaTerm;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaReleaseInfoCheck
extends BaseJavaTermCheck {
    private static final Pattern _variablePattern = Pattern.compile("(=\\s+\").*\";");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        String javaTermContent = javaTerm.getContent();
        if (!absolutePath.contains("/kernel/util/ReleaseInfo.java")) {
            return javaTermContent;
        }
        String variableName = javaTerm.getName();
        if (variableName.equals("_BUILD")) {
            return this._fixVariable(javaTermContent, "@release.info.build@");
        }
        if (variableName.equals("_DATE")) {
            return this._fixVariable(javaTermContent, "@release.info.date@");
        }
        if (variableName.equals("_NAME")) {
            return this._fixVariable(javaTermContent, "@release.info.name@");
        }
        if (variableName.equals("_VERSION")) {
            return this._fixVariable(javaTermContent, "@release.info.version@");
        }
        if (variableName.equals("_VERSION_DISPLAY_NAME")) {
            return this._fixVariable(javaTermContent, "@release.info.version.display.name@");
        }
        return javaTermContent;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_VARIABLE};
    }

    private String _fixVariable(String content, String expectedVariableValue) {
        Matcher matcher = _variablePattern.matcher(content);
        return matcher.replaceAll("$1" + expectedVariableValue + "\";");
    }
}

