/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.servlet.ServletContextClassLoaderPool;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalLifecycle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PortalLifecycleUtil {
    private static boolean _inFlushDestroys;
    private static final List<PortalLifecycle> _portalLifecyclesDestroy;
    private static List<PortalLifecycle> _portalLifecyclesInit;

    public static void flushDestroys() {
        _inFlushDestroys = true;
        for (int i = _portalLifecyclesDestroy.size() - 1; i >= 0; --i) {
            PortalLifecycle portalLifecycle = _portalLifecyclesDestroy.get(i);
            portalLifecycle.portalDestroy();
        }
        _portalLifecyclesDestroy.clear();
        _inFlushDestroys = false;
    }

    public static void flushInits() {
        if (_portalLifecyclesInit != null) {
            List<PortalLifecycle> portalLifecyclesInit = _portalLifecyclesInit;
            _portalLifecyclesInit = null;
            for (PortalLifecycle portalLifecycle : portalLifecyclesInit) {
                portalLifecycle.portalInit();
            }
        }
    }

    public static void register(PortalLifecycle portalLifecycle) {
        PortalLifecycleUtil.register(portalLifecycle, 0);
    }

    public static void register(PortalLifecycle portalLifecycle, int method) {
        if (method == 0 || method == 2) {
            if (_portalLifecyclesInit == null) {
                Thread currentThread = Thread.currentThread();
                ClassLoader classLoader = currentThread.getContextClassLoader();
                if (PortalClassLoaderUtil.isPortalClassLoader(classLoader) || !HotDeployUtil.registerDependentPortalLifecycle((String)ServletContextClassLoaderPool.getServletContextName((ClassLoader)classLoader), (PortalLifecycle)portalLifecycle)) {
                    portalLifecycle.portalInit();
                }
            } else {
                _portalLifecyclesInit.add(portalLifecycle);
            }
        }
        if (method == 0 || method == 1) {
            _portalLifecyclesDestroy.add(portalLifecycle);
        }
    }

    public static void removeDestroy(PortalLifecycle portalLifecycle) {
        if (!_inFlushDestroys) {
            _portalLifecyclesDestroy.remove(portalLifecycle);
        }
    }

    public static void reset() {
        _inFlushDestroys = false;
        if (_portalLifecyclesInit == null) {
            _portalLifecyclesInit = Collections.synchronizedList(new ArrayList());
        } else {
            _portalLifecyclesInit.clear();
        }
        _portalLifecyclesDestroy.clear();
    }

    static {
        _portalLifecyclesDestroy = Collections.synchronizedList(new ArrayList());
        _portalLifecyclesInit = Collections.synchronizedList(new ArrayList());
    }
}

