/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONObject;

public class ModulesPropertiesUtil {
    private static final String[] _SKIP_DIR_NAMES = new String[]{".git", ".gradle", ".idea", ".m2", ".settings", "bin", "build", "classes", "dependencies", "node_modules", "node_modules_cache", "private", "sdk", "sql", "src", "test", "test-classes", "test-coverage", "test-results", "tmp"};

    public static String getContent(File portalDir) throws IOException {
        StringBundler sb = new StringBundler();
        Map<String, String> moduleInformationMap = ModulesPropertiesUtil._getModuleInformationMap(portalDir);
        for (Map.Entry<String, String> entry : moduleInformationMap.entrySet()) {
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        if (!moduleInformationMap.isEmpty()) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private static String _getBundleSymbolicName(String bndContent, String absolutePath) {
        if (absolutePath.endsWith("/portal-impl/bnd.bnd")) {
            return "com.liferay.portal.impl";
        }
        if (absolutePath.endsWith("/portal-kernel/bnd.bnd")) {
            return "com.liferay.portal.kernel";
        }
        if (absolutePath.endsWith("/portal-test-integration/bnd.bnd")) {
            return "com.liferay.portal.test.integration";
        }
        if (absolutePath.endsWith("/portal-test/bnd.bnd")) {
            return "com.liferay.portal.test";
        }
        if (absolutePath.endsWith("/portal-support-tomcat/bnd.bnd")) {
            return "com.liferay.support.tomcat";
        }
        if (absolutePath.endsWith("/util-bridges/bnd.bnd")) {
            return "com.liferay.util.bridges";
        }
        if (absolutePath.endsWith("/util-java/bnd.bnd")) {
            return "com.liferay.util.java";
        }
        if (absolutePath.endsWith("/util-slf4j/bnd.bnd")) {
            return "com.liferay.util.slf4j";
        }
        if (absolutePath.endsWith("/util-taglib/bnd.bnd")) {
            return "com.liferay.util.taglib";
        }
        String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(bndContent, "Bundle-SymbolicName");
        if (Validator.isNotNull(bundleSymbolicName) && bundleSymbolicName.startsWith("com.liferay.")) {
            return bundleSymbolicName;
        }
        return null;
    }

    private static Map<String, String> _getModuleInformationMap(File portalDir) throws IOException {
        if (portalDir == null) {
            return Collections.emptyMap();
        }
        final TreeMap<String, String> moduleInformationMap = new TreeMap<String, String>();
        Files.walkFileTree(portalDir.toPath(), EnumSet.noneOf(FileVisitOption.class), 15, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                Path packageJSONPath;
                String absolutePath;
                int x;
                String dirName = String.valueOf(dirPath.getFileName());
                if (ArrayUtil.contains(_SKIP_DIR_NAMES, dirName)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path path = dirPath.resolve(".gitrepo");
                if (Files.exists(path, new LinkOption[0])) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path bndPath = dirPath.resolve("bnd.bnd");
                if (!Files.exists(bndPath, new LinkOption[0])) {
                    return FileVisitResult.CONTINUE;
                }
                String bndContent = FileUtil.read(bndPath.toFile());
                String bundleSymbolicName = ModulesPropertiesUtil._getBundleSymbolicName(bndContent, SourceUtil.getAbsolutePath(bndPath));
                if (bundleSymbolicName == null) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                String bundleVersion = BNDSourceUtil.getDefinitionValue(bndContent, "Bundle-Version");
                if (Validator.isNotNull(bundleVersion)) {
                    moduleInformationMap.put("bundle.version[" + bundleSymbolicName + "]", bundleVersion);
                }
                if ((x = (absolutePath = SourceUtil.getAbsolutePath(dirPath)).indexOf("/modules/")) != -1) {
                    moduleInformationMap.put("project.name[" + bundleSymbolicName + "]", StringUtil.replace(absolutePath.substring(x + 8), '/', ':'));
                }
                if (!Files.exists(packageJSONPath = dirPath.resolve("package.json"), new LinkOption[0])) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                JSONObject jsonObject = new JSONObject(FileUtil.read(packageJSONPath.toFile()));
                if (!jsonObject.isNull("name")) {
                    moduleInformationMap.put("bundle.symbolic.name[" + jsonObject.getString("name") + "]", bundleSymbolicName);
                }
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
        return moduleInformationMap;
    }
}

