/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class ValidatorIsNullCheck
extends BaseCheck {
    private static final String _MSG_INVALID_METHOD_NAME = "method.invalidName";
    private static final String _MSG_RESERVED_METHOD = "method.reserved";

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        this._checkMethod(detailAST, "Validator", "isNotNull");
        this._checkMethod(detailAST, "Validator", "isNull");
    }

    private void _checkMethod(DetailAST detailAST, String className, String methodName) {
        List<DetailAST> methodCallDetailASTList = DetailASTUtil.getMethodCalls(detailAST, className, methodName);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            DetailAST typeDetailAST;
            DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
            DetailAST expressionDetailAST = elistDetailAST.findFirstToken(28);
            DetailAST childDetailAST = expressionDetailAST.getFirstChild();
            if (childDetailAST.getType() == 137) {
                this.log(methodCallDetailAST, _MSG_INVALID_METHOD_NAME, new Object[]{StringBundler.concat(className, ".", methodName, "(long)")});
                continue;
            }
            if (childDetailAST.getType() != 58 || (typeDetailAST = DetailASTUtil.getVariableTypeDetailAST(methodCallDetailAST, childDetailAST.getText())) == null) continue;
            childDetailAST = typeDetailAST.getFirstChild();
            if (childDetailAST.getType() == 54 || childDetailAST.getType() == 56) {
                this.log(methodCallDetailAST, _MSG_INVALID_METHOD_NAME, new Object[]{StringBundler.concat(className, ".", methodName, "(long)")});
                continue;
            }
            String typeName = DetailASTUtil.getTypeName(typeDetailAST, true);
            if (!Validator.isNotNull(typeName) || typeName.equals("Long") || typeName.equals("Object") || typeName.equals("Serializable") || typeName.equals("String")) continue;
            this.log(methodCallDetailAST, _MSG_RESERVED_METHOD, new Object[]{StringBundler.concat(className, ".", methodName)});
        }
    }
}

