/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import java.util.Objects;

public class ThreadLocalUtilCheck
extends BaseCheck {
    private static final String _MSG_USE_THREAD_LOCAL_UTIL = "thread.local.util.use";

    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        FileContents fileContents = this.getFileContents();
        String fileName = StringUtil.replace(fileContents.getFileName(), '\\', '/');
        if (!fileName.contains("/util-taglib/") || !Objects.equals(DetailASTUtil.getTypeName(detailAST, false), "ThreadLocal")) {
            return;
        }
        DetailAST assignDetailAST = detailAST.findFirstToken(80);
        if (assignDetailAST == null) {
            return;
        }
        DetailAST firstChildDetailAST = assignDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 28) {
            return;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() == 136) {
            DetailAST nameDetailAST = detailAST.findFirstToken(58);
            this.log(detailAST, _MSG_USE_THREAD_LOCAL_UTIL, new Object[]{nameDetailAST.getText()});
        }
    }
}

