/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.source.formatter.checkstyle.checks.ChainedMethodCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MapBuilderCheck
extends ChainedMethodCheck {
    private static final String _CHECK_ANONYMOUS_CLASS_KEY = "checkAnonymousClass";
    private static final String _MAP_TYPE_NAMES_KEY = "mapTypeNames";
    private static final String _MSG_CAST_NULL_VALUE = "null.value.cast";
    private static final String _MSG_INCLUDE_MAP_BUILDER = "map.builder.include";
    private static final String _MSG_INLINE_MAP_BUILDER = "map.builder.inline";
    private static final String _MSG_USE_MAP_BUILDER = "map.builder.use";
    private static final String _MSG_USE_MAP_BUILDER_INSTEAD = "map.builder.use.instead";
    private static final String _RUN_OUTSIDE_PORTAL_EXCLUDES = "run.outside.portal.excludes";

    public int[] getDefaultTokens() {
        return new int[]{80, 11, 27};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (this.isExcludedPath(_RUN_OUTSIDE_PORTAL_EXCLUDES)) {
            return;
        }
        if (detailAST.getType() == 11 && this.isAttributeValue(_CHECK_ANONYMOUS_CLASS_KEY)) {
            this._checkAnonymousClass(detailAST);
            return;
        }
        if (detailAST.getType() == 27) {
            this._checkMapBuilder(detailAST);
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 28 && parentDetailAST.getType() != 10) {
            return;
        }
        DetailAST nextSiblingDetailAST = parentDetailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 45) {
            return;
        }
        String variableName = this.getVariableName(detailAST, parentDetailAST);
        if (variableName == null) {
            return;
        }
        this._checkNewInstance(detailAST, variableName, parentDetailAST, nextSiblingDetailAST);
    }

    private void _checkAnonymousClass(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 6) {
            return;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 136) {
            return;
        }
        DetailAST identDetailAST = parentDetailAST.findFirstToken(58);
        if (identDetailAST == null) {
            return;
        }
        String className = identDetailAST.getText();
        List<String> mapTypeNames = this.getAttributeValues(_MAP_TYPE_NAMES_KEY);
        if (!mapTypeNames.contains(className)) {
            return;
        }
        List<DetailAST> loopDetailASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 175, 91, 84);
        if (!loopDetailASTList.isEmpty()) {
            return;
        }
        List<DetailAST> methodCallDetailASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            DetailAST firstChildDetailAST;
            parentDetailAST = methodCallDetailAST.getParent();
            if (parentDetailAST.getType() != 28 || (parentDetailAST = parentDetailAST.getParent()).getType() != 7 || (firstChildDetailAST = methodCallDetailAST.getFirstChild()).getType() != 58 || Objects.equals(firstChildDetailAST.getText(), "put")) continue;
            return;
        }
        this.log(detailAST, _MSG_USE_MAP_BUILDER_INSTEAD, new Object[]{className + "Builder", className});
    }

    private void _checkInline(DetailAST parentDetailAST, List<DetailAST> methodVariableDetailASTList, String className) {
        ArrayList<String> followingVariableNames = new ArrayList<String>();
        for (DetailAST nextSiblingDetailAST = parentDetailAST.getNextSibling(); nextSiblingDetailAST != null; nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) {
            followingVariableNames.addAll(this._getVariableNames(nextSiblingDetailAST));
        }
        ArrayList<String> inBetweenVariableNames = new ArrayList<String>();
        DetailAST previousSiblingDetailAST = parentDetailAST.getPreviousSibling();
        while (previousSiblingDetailAST != null) {
            if (previousSiblingDetailAST.getType() != 10) {
                followingVariableNames.addAll(this._getVariableNames(previousSiblingDetailAST));
                inBetweenVariableNames.addAll(this._getVariableNames(previousSiblingDetailAST, "get.*"));
                previousSiblingDetailAST = previousSiblingDetailAST.getPreviousSibling();
                continue;
            }
            DetailAST identDetailAST = previousSiblingDetailAST.findFirstToken(58);
            String name = identDetailAST.getText();
            DetailAST matchingMethodVariableDetailAST = this._getExprDetailAST(methodVariableDetailASTList, name);
            if (!followingVariableNames.contains(name) && matchingMethodVariableDetailAST != null && !this._referencesNonfinalVariable(previousSiblingDetailAST)) {
                List<String> variableNames = this._getVariableNames(previousSiblingDetailAST);
                boolean contains = false;
                for (String variableName : variableNames) {
                    if (!inBetweenVariableNames.contains(variableName)) continue;
                    contains = true;
                    break;
                }
                if (!contains) {
                    this.log(identDetailAST, _MSG_INLINE_MAP_BUILDER, new Object[]{name, identDetailAST.getLineNo(), className + ".put", parentDetailAST.getLineNo()});
                }
            }
            followingVariableNames.addAll(this._getVariableNames(previousSiblingDetailAST));
            inBetweenVariableNames.addAll(this._getVariableNames(previousSiblingDetailAST, "get.*"));
            previousSiblingDetailAST = previousSiblingDetailAST.getPreviousSibling();
        }
        return;
    }

    private void _checkMapBuilder(DetailAST methodCallDetailAST) {
        DetailAST greatGrandParentDetailAST;
        DetailAST firstChildDetailAST = methodCallDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 59) {
            return;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() != 58) {
            return;
        }
        String className = firstChildDetailAST.getText();
        if (!className.endsWith("Builder")) {
            return;
        }
        List<String> mapTypeNames = this.getAttributeValues(_MAP_TYPE_NAMES_KEY);
        if (!mapTypeNames.contains(className.substring(0, className.length() - 7))) {
            return;
        }
        List<DetailAST> methodVariableDetailASTList = this._getMethodVariableDetailASTList(methodCallDetailAST);
        this._checkNullValues(methodVariableDetailASTList, className);
        DetailAST parentDetailAST = methodCallDetailAST.getParent();
        while (parentDetailAST.getType() == 59 || parentDetailAST.getType() == 28 || parentDetailAST.getType() == 27) {
            parentDetailAST = parentDetailAST.getParent();
        }
        if (parentDetailAST.getType() == 88) {
            this._checkInline(parentDetailAST, methodVariableDetailASTList, className);
        }
        if (parentDetailAST.getType() != 80) {
            return;
        }
        DetailAST assignDetailAST = parentDetailAST;
        DetailAST grandParentDetailAST = (parentDetailAST = assignDetailAST.getParent()).getParent();
        if (grandParentDetailAST.getType() == 6 && (greatGrandParentDetailAST = grandParentDetailAST.getParent()).getType() == 14) {
            return;
        }
        this._checkInline(parentDetailAST, methodVariableDetailASTList, className);
        firstChildDetailAST = assignDetailAST.getFirstChild();
        DetailAST assignValueDetailAST = null;
        assignValueDetailAST = parentDetailAST.getType() == 28 ? firstChildDetailAST.getNextSibling() : firstChildDetailAST.getFirstChild();
        if (assignValueDetailAST == null || assignValueDetailAST.getType() != 27) {
            return;
        }
        firstChildDetailAST = assignValueDetailAST.getFirstChild();
        List<String> variableNames = this._getVariableNames(parentDetailAST, "get.*");
        String variableName = this.getVariableName(assignDetailAST, parentDetailAST);
        variableNames.add(variableName);
        DetailAST nextSiblingDetailAST = parentDetailAST.getNextSibling();
        while (nextSiblingDetailAST != null) {
            FullIdent fullIdent = this.getMethodCallFullIdent(nextSiblingDetailAST, variableName, "put");
            if (fullIdent != null) {
                this.log(assignDetailAST, _MSG_INCLUDE_MAP_BUILDER, new Object[]{fullIdent.getText(), fullIdent.getLineNo(), className + ".put", assignDetailAST.getLineNo()});
                return;
            }
            for (String curVariableName : variableNames) {
                if (!this.containsVariableName(nextSiblingDetailAST, curVariableName)) continue;
                return;
            }
            nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling();
        }
        return;
    }

    private void _checkNewInstance(DetailAST detailAST, String variableName, DetailAST parentDetailAST, DetailAST nextSiblingDetailAST) {
        String newInstanceTypeName = this._getNewInstanceTypeName(detailAST, parentDetailAST);
        if (newInstanceTypeName == null) {
            return;
        }
        List<String> mapTypeNames = this.getAttributeValues(_MAP_TYPE_NAMES_KEY);
        if (!mapTypeNames.contains(newInstanceTypeName)) {
            return;
        }
        do {
            if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) == null) {
                return;
            }
            FullIdent fullIdent = this.getMethodCallFullIdent(nextSiblingDetailAST, variableName, "put");
            if (fullIdent == null) continue;
            this.log(detailAST, _MSG_USE_MAP_BUILDER, new Object[]{newInstanceTypeName + "Builder", detailAST.getLineNo(), fullIdent.getLineNo()});
            return;
        } while (!this.containsVariableName(nextSiblingDetailAST, variableName));
    }

    private void _checkNullValues(List<DetailAST> methodVariableDetailASTList, String className) {
        for (DetailAST methodVariableDetailAST : methodVariableDetailASTList) {
            DetailAST firstChildDetailAST;
            if (methodVariableDetailAST.getType() != 28 || (firstChildDetailAST = methodVariableDetailAST.getFirstChild()).getType() != 135) continue;
            this.log(firstChildDetailAST, _MSG_CAST_NULL_VALUE, new Object[]{className});
        }
    }

    private DetailAST _getExprDetailAST(List<DetailAST> exprDetailASTList, String name) {
        DetailAST exprDetailAST = null;
        for (DetailAST curExprDetailAST : exprDetailASTList) {
            List<String> variableNames = this._getVariableNames(curExprDetailAST);
            if (!variableNames.contains(name)) continue;
            if (exprDetailAST != null) {
                return null;
            }
            exprDetailAST = curExprDetailAST;
        }
        return exprDetailAST;
    }

    private List<DetailAST> _getMethodVariableDetailASTList(DetailAST methodCallDetailAST) {
        ArrayList<DetailAST> exprDetailASTList = new ArrayList<DetailAST>();
        while (true) {
            DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
            for (DetailAST childDetailAST = elistDetailAST.getFirstChild(); childDetailAST != null; childDetailAST = childDetailAST.getNextSibling()) {
                if (childDetailAST.getType() == 74) continue;
                exprDetailASTList.add(childDetailAST);
            }
            DetailAST parentDetailAST = methodCallDetailAST.getParent();
            if (parentDetailAST.getType() != 59) {
                return exprDetailASTList;
            }
            methodCallDetailAST = parentDetailAST.getParent();
        }
    }

    private String _getNewInstanceTypeName(DetailAST assignDetailAST, DetailAST parentDetailAST) {
        DetailAST firstChildDetailAST = assignDetailAST.getFirstChild();
        DetailAST assignValueDetailAST = null;
        assignValueDetailAST = parentDetailAST.getType() == 28 ? firstChildDetailAST.getNextSibling() : firstChildDetailAST.getFirstChild();
        if (assignValueDetailAST == null || assignValueDetailAST.getType() != 136) {
            return null;
        }
        DetailAST identDetailAST = assignValueDetailAST.findFirstToken(58);
        if (identDetailAST == null) {
            return null;
        }
        DetailAST elistDetailAST = assignValueDetailAST.findFirstToken(34);
        if (elistDetailAST == null || elistDetailAST.getFirstChild() != null) {
            return null;
        }
        return identDetailAST.getText();
    }

    private List<String> _getVariableNames(DetailAST detailAST) {
        return this._getVariableNames(detailAST, null);
    }

    private List<String> _getVariableNames(DetailAST detailAST, String excludeRegex) {
        ArrayList<String> variableNames = new ArrayList<String>();
        List<DetailAST> identDetailASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 58);
        for (DetailAST identDetailAST : identDetailASTList) {
            DetailAST nextSiblingDetailAST;
            String variableName = identDetailAST.getText();
            if (!variableName.matches("[a-z_].*")) continue;
            DetailAST parentDetailAST = identDetailAST.getParent();
            if (parentDetailAST.getType() == 80 || parentDetailAST.getType() == 28 || parentDetailAST.getType() == 23 || ArrayUtil.contains(ARITHMETIC_OPERATOR_TOKEN_TYPES, parentDetailAST.getType()) || ArrayUtil.contains(RELATIONAL_OPERATOR_TOKEN_TYPES, parentDetailAST.getType())) {
                variableNames.add(variableName);
                continue;
            }
            if (parentDetailAST.getType() != 59 || (nextSiblingDetailAST = identDetailAST.getNextSibling()) == null) continue;
            if (nextSiblingDetailAST.getType() != 58 || excludeRegex == null) {
                variableNames.add(variableName);
                continue;
            }
            String s = nextSiblingDetailAST.getText();
            if (s.matches(excludeRegex)) continue;
            variableNames.add(variableName);
        }
        return variableNames;
    }

    private boolean _referencesNonfinalVariable(DetailAST detailAST) {
        List<String> variableNames = this._getVariableNames(detailAST);
        DetailAST previousDetailAST = detailAST.getPreviousSibling();
        DetailAST parentDetailAST = detailAST.getParent();
        while (true) {
            if (previousDetailAST != null) {
                DetailAST identDetailAST;
                DetailAST firstChildDetailAST;
                if (previousDetailAST.getType() == 28 && (firstChildDetailAST = previousDetailAST.getFirstChild()).getType() == 80 && variableNames.contains((identDetailAST = firstChildDetailAST.findFirstToken(58)).getText())) {
                    return true;
                }
                previousDetailAST = previousDetailAST.getPreviousSibling();
                continue;
            }
            if (parentDetailAST == null) {
                return false;
            }
            previousDetailAST = parentDetailAST;
            parentDetailAST = parentDetailAST.getParent();
        }
    }
}

