/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaPackagePathCheck
extends BaseJavaTermCheck {
    private static final String _ALLOWED_INTERNAL_PACKAGE_DIR_NAMES_KEY = "allowedInternalPackageDirNames";
    private static final String _EXPECTED_INTERNAL_IMPLEMENTS_DATA_KEY = "expectedInternalImplementsData";
    private static final Pattern _apiOrServiceBundleSymbolicNamePattern = Pattern.compile("\\.(api|service)$");
    private static final Pattern _internalPackagePattern = Pattern.compile("\\.(impl|internal)(\\.|\\Z)");

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        String className;
        if (javaTerm.getParentJavaClass() != null) {
            return javaTerm.getContent();
        }
        JavaClass javaClass = (JavaClass)javaTerm;
        if (javaClass.isAnonymous()) {
            return javaTerm.getContent();
        }
        String packageName = javaClass.getPackageName();
        if (Validator.isNull(packageName)) {
            this.addMessage(fileName, "Missing package");
            return javaTerm.getContent();
        }
        this._checkPackageName(fileName, absolutePath, packageName, javaClass.getName());
        if (this.isModulesFile(absolutePath) && !this.isModulesApp(absolutePath, true)) {
            this._checkModulePackageName(fileName, packageName);
        }
        if ((className = javaClass.getName()).startsWith("Base")) {
            return javaTerm.getContent();
        }
        List<String> expectedInternalImplementsDataEntries = this.getAttributeValues(_EXPECTED_INTERNAL_IMPLEMENTS_DATA_KEY, absolutePath);
        for (String expectedInternalImplementsDataEntry : expectedInternalImplementsDataEntries) {
            String[] array = StringUtil.split(expectedInternalImplementsDataEntry, ':');
            if (array.length != 2) continue;
            this._checkPackageName(fileName, javaClass.getImplementedClassNames(), array[0], packageName, array[1], true);
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private void _checkModulePackageName(String fileName, String packageName) throws IOException {
        if (!packageName.startsWith("com.liferay")) {
            return;
        }
        BNDSettings bndSettings = this.getBNDSettings(fileName);
        if (bndSettings == null) {
            return;
        }
        String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(bndSettings.getContent(), "Bundle-SymbolicName");
        if (!bundleSymbolicName.startsWith("com.liferay")) {
            return;
        }
        if (packageName.contains(bundleSymbolicName = bundleSymbolicName.replaceAll("\\.(api|service|test)$", ""))) {
            return;
        }
        if (!packageName.contains(bundleSymbolicName = bundleSymbolicName.replaceAll("\\.impl$", ".internal"))) {
            this.addMessage(fileName, "Package should follow Bundle-SymbolicName specified in " + bndSettings.getFileName(), "package.markdown");
        }
    }

    private void _checkPackageName(String fileName, List<String> implementedClassNames, String implementedClassName, String packageName, String expectedPackageName, boolean internal) throws IOException {
        if (!implementedClassNames.contains(implementedClassName)) {
            return;
        }
        if (internal && !packageName.contains(".internal.") && !packageName.endsWith(".internal")) {
            this.addMessage(fileName, StringBundler.concat("Class implementing '", implementedClassName, "' should be in 'internal' package"));
        }
        if (packageName.endsWith(expectedPackageName)) {
            return;
        }
        BNDSettings bndSettings = this.getBNDSettings(fileName);
        if (bndSettings == null) {
            return;
        }
        String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(bndSettings.getContent(), "Bundle-SymbolicName");
        Matcher matcher = _apiOrServiceBundleSymbolicNamePattern.matcher(bundleSymbolicName);
        if ((bundleSymbolicName = matcher.replaceAll("")).endsWith(expectedPackageName)) {
            return;
        }
        int x = -1;
        while ((x = expectedPackageName.indexOf(".", x + 1)) != -1) {
            if (!bundleSymbolicName.endsWith(expectedPackageName.substring(0, x))) continue;
            expectedPackageName = expectedPackageName.substring(x + 1);
            break;
        }
        if (!packageName.endsWith(expectedPackageName)) {
            this.addMessage(fileName, StringBundler.concat("Package for class implementing '", implementedClassName, "' should end with '", expectedPackageName, "'"));
        }
    }

    private void _checkPackageName(String fileName, String absolutePath, String packageName, String className) {
        int pos = fileName.lastIndexOf(47);
        String filePath = StringUtil.replace(fileName.substring(0, pos), '/', '.');
        if (!filePath.endsWith(packageName)) {
            this.addMessage(fileName, "The declared package '" + packageName + "' does not match the expected package", "package.markdown");
            return;
        }
        if (packageName.matches(".*\\.impl\\.([\\w.]+\\.)?internal") || packageName.matches(".*\\.internal\\.([\\w.]+\\.)?impl")) {
            this.addMessage(fileName, "Do not use both 'impl' and 'internal' in the package", "package.markdown");
        }
        List<String> allowedInternalPackageDirNames = this.getAttributeValues(_ALLOWED_INTERNAL_PACKAGE_DIR_NAMES_KEY, absolutePath);
        for (String allowedInternalPackageDirName : allowedInternalPackageDirNames) {
            if (!absolutePath.contains(allowedInternalPackageDirName)) continue;
            return;
        }
        if (absolutePath.contains("-api/src/")) {
            Matcher matcher = _internalPackagePattern.matcher(packageName);
            if (matcher.find()) {
                this.addMessage(fileName, "Do not use '" + matcher.group(1) + "' package in API module", "package.markdown");
            }
            if (packageName.contains(".api.") || packageName.endsWith(".api")) {
                this.addMessage(fileName, "Do not use 'api' in the package for classes in the API module");
            }
        }
        if (className.endsWith("OSGiCommands") && !packageName.endsWith(".osgi.commands")) {
            this.addMessage(fileName, "Class '" + className + "' should be in package ending with '.osgi.commands'");
        }
        if (className.matches(".*(?<!Display)Context") && packageName.endsWith(".display.context")) {
            this.addMessage(fileName, "The name of Class '" + className + "' should be ending with 'DisplayContext'");
        }
        if (this.isModulesFile(absolutePath) && className.equals("ServletContextUtil") && !packageName.contains(".internal")) {
            this.addMessage(fileName, "Class '" + className + "' should be in 'internal' package");
        }
    }
}

