/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;

public class JavaModuleExtendedObjectClassDefinitionCheck
extends BaseFileCheck {
    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (absolutePath.contains("/test/") || !content.contains("@Meta.OCD(") || content.contains("@ExtendedObjectClassDefinition")) {
            return content;
        }
        String packageName = JavaSourceUtil.getPackageName(content);
        if (!packageName.startsWith("com.liferay")) {
            return content;
        }
        this.addMessage(fileName, "Specify category using @ExtendedObjectClassDefinition, see LPS-60186");
        return content;
    }
}

