/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.DockerfileSourceUtil;
import java.io.IOException;

public class DockerfileEmptyLinesCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String instruction = "";
            String line = "";
            String previousInstruction = "";
            String previousLine = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (Validator.isNull(line)) continue;
                instruction = DockerfileSourceUtil.getInstruction(line, previousLine);
                if (DockerfileSourceUtil.isNewInstruction(instruction, previousInstruction, previousLine)) {
                    sb.append("\n");
                }
                sb.append(line);
                sb.append("\n");
                if (Validator.isNotNull(instruction)) {
                    previousInstruction = instruction;
                }
                previousLine = line;
            }
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }
}

