/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.java.parser;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.tools.java.parser.BaseJavaTerm;
import com.liferay.portal.tools.java.parser.JavaSimpleValue;
import java.util.List;

public class JavaType
extends BaseJavaTerm
implements Comparable<JavaType> {
    private final int _arrayDimension;
    private List<JavaType> _genericJavaTypes;
    private List<JavaType> _lowerBoundJavaTypes;
    private final JavaSimpleValue _name;
    private List<JavaType> _upperBoundJavaTypes;
    private boolean _varargs;

    public JavaType(String name, int arrayDimension) {
        this._name = new JavaSimpleValue(name);
        this._arrayDimension = arrayDimension;
    }

    @Override
    public int compareTo(JavaType javaType) {
        NaturalOrderStringComparator comparator = new NaturalOrderStringComparator();
        return comparator.compare(this.getName(), javaType.getName());
    }

    public String getName() {
        return this._name.getName();
    }

    public void setGenericJavaTypes(List<JavaType> genericJavaTypes) {
        this._genericJavaTypes = genericJavaTypes;
    }

    public void setLowerBoundJavaTypes(List<JavaType> lowerBoundJavaTypes) {
        this._lowerBoundJavaTypes = lowerBoundJavaTypes;
    }

    public void setUpperBoundJavaTypes(List<JavaType> upperBoundJavaTypes) {
        this._upperBoundJavaTypes = upperBoundJavaTypes;
    }

    public void setVarargs(boolean varargs) {
        this._varargs = varargs;
    }

    @Override
    public String toString(String indent, String prefix, String suffix, int maxLineLength) {
        return this.toString(indent, prefix, suffix, maxLineLength, false);
    }

    @Override
    public String toString(String indent, String prefix, String suffix, int maxLineLength, boolean forceLineBreak) {
        StringBundler sb = new StringBundler();
        for (int i = 0; i < this._arrayDimension; ++i) {
            sb.append("[]");
        }
        if (this._varargs) {
            sb.append("...");
        }
        sb.append(suffix);
        suffix = sb.toString();
        sb = new StringBundler();
        sb.append(indent);
        indent = "\t" + indent;
        if (this._genericJavaTypes == null && this._lowerBoundJavaTypes == null && this._upperBoundJavaTypes == null) {
            this.append(sb, this._name, indent, prefix, suffix, maxLineLength, !forceLineBreak);
            return sb.toString();
        }
        if (!this.appendSingleLine(sb, this._name, prefix, "", maxLineLength)) {
            indent = this.append(sb, this._name, indent, prefix, "", maxLineLength, !forceLineBreak);
        } else if (forceLineBreak) {
            indent = this.adjustIndent(sb, indent);
            sb.append("\n");
            sb.append(indent);
        }
        if (this._genericJavaTypes != null) {
            this.append(sb, this._genericJavaTypes, indent, "<", ">" + suffix, maxLineLength);
        } else if (this._lowerBoundJavaTypes != null) {
            if (this._lowerBoundJavaTypes.size() == 1) {
                this.append(sb, this._lowerBoundJavaTypes.get(0), indent, " super ", suffix, maxLineLength, false);
            } else {
                indent = this.append(sb, this._lowerBoundJavaTypes, " & ", indent, " super ", suffix, maxLineLength);
            }
        } else if (this._upperBoundJavaTypes != null) {
            if (this._upperBoundJavaTypes.size() == 1) {
                this.append(sb, this._upperBoundJavaTypes.get(0), indent, " extends ", suffix, maxLineLength, false);
            } else {
                this.append(sb, this._upperBoundJavaTypes, " & ", indent, " extends ", suffix, maxLineLength);
            }
        }
        return sb.toString();
    }
}

