/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.process.CollectorOutputProcessor;
import com.liferay.petra.process.OutputProcessor;
import com.liferay.petra.process.ProcessUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HeapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.Date;
import java.util.Map;

public class ThreadUtil {
    private static final Log _log = LogFactoryUtil.getLog(ThreadUtil.class);

    public static Thread[] getThreads() {
        Thread currentThread = Thread.currentThread();
        ThreadGroup threadGroup = currentThread.getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        int threadCountGuess = threadGroup.activeCount();
        Thread[] threads = new Thread[threadCountGuess];
        int threadCountActual = threadGroup.enumerate(threads);
        while (threadCountActual == threadCountGuess) {
            threads = new Thread[threadCountGuess *= 2];
            threadCountActual = threadGroup.enumerate(threads);
        }
        return threads;
    }

    public static String threadDump() {
        String threadDump = ThreadUtil._getThreadDumpFromJstack();
        if (Validator.isNull(threadDump)) {
            threadDump = ThreadUtil._getThreadDumpFromStackTrace();
        }
        return "\n\n".concat(threadDump);
    }

    private static String _getThreadDumpFromJstack() {
        String vendorURL = System.getProperty("java.vendor.url");
        if (!vendorURL.equals("http://java.oracle.com/") && !vendorURL.equals("http://java.sun.com/") || !HeapUtil.isSupported()) {
            return "";
        }
        try {
            NoticeableFuture noticeableFuture = ProcessUtil.execute((OutputProcessor)CollectorOutputProcessor.INSTANCE, (String[])new String[]{"jstack", "-l", String.valueOf(HeapUtil.getProcessId())});
            Map.Entry entry = (Map.Entry)noticeableFuture.get();
            return new String((byte[])entry.getKey());
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to use jstack to get thread dump for process " + HeapUtil.getProcessId(), e);
            }
            return "";
        }
    }

    private static String _getThreadDumpFromStackTrace() {
        String jvm = System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version");
        StringBundler sb = new StringBundler(StringBundler.concat("Full thread dump of ", jvm, " on ", String.valueOf(new Date()), "\n\n"));
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
            Thread thread = entry.getKey();
            StackTraceElement[] elements = entry.getValue();
            sb.append("\"");
            sb.append(thread.getName());
            sb.append("\"");
            if (thread.getThreadGroup() != null) {
                sb.append(" ");
                sb.append("(");
                ThreadGroup threadGroup = thread.getThreadGroup();
                sb.append(threadGroup.getName());
                sb.append(")");
            }
            sb.append(", priority=");
            sb.append(thread.getPriority());
            sb.append(", id=");
            sb.append(thread.getId());
            sb.append(", state=");
            sb.append((Object)thread.getState());
            sb.append("\n");
            for (StackTraceElement element : elements) {
                sb.append("\t");
                sb.append(element);
                sb.append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

