/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.ArrayList;
import java.util.List;

public class VariableDeclarationAsUsedCheck
extends BaseCheck {
    private static final String _MSG_DECLARE_VARIABLE_AS_USED = "variable.declare.as.used";
    private static final String _MSG_VARIABLE_DECLARTION_NOT_NEEDED = "variable.declaration.not.needed";

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<DetailAST> variableDefinitionDetailASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 10);
        if (variableDefinitionDetailASTList.isEmpty()) {
            return;
        }
        for (DetailAST variableDefinitionDetailAST : variableDefinitionDetailASTList) {
            this._checkAsUsed(detailAST, variableDefinitionDetailAST);
        }
    }

    private void _checkAsUsed(DetailAST detailAST, DetailAST variableDefinitionDetailAST) {
        FileContents fileContents;
        String fileName;
        List<DetailAST> identDetailASTList;
        List<String> identValues = this._getIdentValues(variableDefinitionDetailAST);
        if (DetailASTUtil.hasParentWithTokenType(variableDefinitionDetailAST, 156, 35) || this._containsMethodName(variableDefinitionDetailAST, "_?(add|channel|close|create|delete|execute|open|post|put|register|resolve|send|transform|unzip|update|zip)([A-Z].*)?", "currentTimeMillis", "nextVersion", "toString") || this._containsVariableType(variableDefinitionDetailAST, identValues, "File")) {
            return;
        }
        DetailAST nameDetailAST = variableDefinitionDetailAST.findFirstToken(58);
        String variableName = nameDetailAST.getText();
        DetailAST firstDependentIdentDetailAST = this._getFirstDependentIdentDetailAST(variableName, identValues, identDetailASTList = this._getIdentDetailASTList(variableDefinitionDetailAST));
        if (firstDependentIdentDetailAST == null) {
            return;
        }
        int endLineNumber = DetailASTUtil.getEndLineNumber(variableDefinitionDetailAST);
        DetailAST lastBranchingStatementDetailAST = this._getLastBranchingStatementDetailAST(detailAST, endLineNumber, this._getClosestParentLineNumber(firstDependentIdentDetailAST, endLineNumber));
        if (lastBranchingStatementDetailAST != null) {
            this.log(variableDefinitionDetailAST, _MSG_DECLARE_VARIABLE_AS_USED, new Object[]{variableName, lastBranchingStatementDetailAST.getText(), lastBranchingStatementDetailAST.getLineNo()});
        }
        if ((fileName = (fileContents = this.getFileContents()).getFileName()).endsWith("Test.java")) {
            return;
        }
        DetailAST assignMethodCallDetailAST = this._getAssignMethodCallDetailAST(variableDefinitionDetailAST);
        if (assignMethodCallDetailAST == null) {
            return;
        }
        DetailAST elistDetailAST = assignMethodCallDetailAST.findFirstToken(34);
        int parameterCount = 0;
        DetailAST childDetailAST = elistDetailAST.getFirstChild();
        while (childDetailAST != null) {
            if (childDetailAST.getType() == 74) {
                childDetailAST = childDetailAST.getNextSibling();
                continue;
            }
            if (childDetailAST.getType() != 28) {
                return;
            }
            if (++parameterCount > 1) {
                return;
            }
            DetailAST grandChildDetailAST = childDetailAST.getFirstChild();
            if (grandChildDetailAST.getType() != 58) {
                return;
            }
            childDetailAST = childDetailAST.getNextSibling();
        }
        DetailAST firstChildDetailAST = assignMethodCallDetailAST.getFirstChild();
        FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
        String methodName = fullIdent.getText();
        if (!methodName.matches("(?i)([\\w.]*\\.)?get" + variableName)) {
            return;
        }
        DetailAST identDetailAST = null;
        for (DetailAST curIdentDetailAST : identDetailASTList) {
            if (curIdentDetailAST.getLineNo() <= nameDetailAST.getLineNo() || !variableName.equals(curIdentDetailAST.getText())) continue;
            if (identDetailAST != null) {
                return;
            }
            identDetailAST = curIdentDetailAST;
            DetailAST parentDetailAST = identDetailAST.getParent();
            if (parentDetailAST.getType() == 28) continue;
            return;
        }
        if (identDetailAST == null || firstDependentIdentDetailAST.getLineNo() < identDetailAST.getLineNo()) {
            return;
        }
        DetailAST parentDetailAST = DetailASTUtil.getParentWithTokenType(identDetailAST, 91, 84, 95, 67, 181);
        if (parentDetailAST != null && parentDetailAST.getLineNo() >= variableDefinitionDetailAST.getLineNo()) {
            return;
        }
        int emptyLineCount = 0;
        for (int i = variableDefinitionDetailAST.getLineNo(); i <= identDetailAST.getLineNo(); ++i) {
            if (!Validator.isNull(this.getLine(i - 1))) continue;
            ++emptyLineCount;
        }
        if (emptyLineCount < 2) {
            this.log(variableDefinitionDetailAST, _MSG_VARIABLE_DECLARTION_NOT_NEEDED, new Object[]{variableName, identDetailAST.getLineNo()});
        }
    }

    private boolean _containsMethodName(DetailAST variableDefinitionDetailAST, String ... methodNameRegexArray) {
        List<DetailAST> methodCallDetailASTList = DetailASTUtil.getAllChildTokens(variableDefinitionDetailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            String methodName = DetailASTUtil.getMethodName(methodCallDetailAST);
            for (String methodNameRegex : methodNameRegexArray) {
                if (!methodName.matches(methodNameRegex)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _containsVariableType(DetailAST variableDefinitionDetailAST, List<String> identValues, String ... variableTypeNames) {
        for (String name : identValues) {
            if (!ArrayUtil.contains(variableTypeNames, DetailASTUtil.getVariableTypeName(variableDefinitionDetailAST, name, false))) continue;
            return true;
        }
        return false;
    }

    private DetailAST _getAssignMethodCallDetailAST(DetailAST variableDefinitionDetailAST) {
        DetailAST assignDetailAST = variableDefinitionDetailAST.findFirstToken(80);
        if (assignDetailAST == null) {
            return null;
        }
        DetailAST firstChildDetailAST = assignDetailAST.getFirstChild();
        if (firstChildDetailAST == null || firstChildDetailAST.getType() != 28) {
            return null;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()) != null && firstChildDetailAST.getType() == 27) {
            return firstChildDetailAST;
        }
        return null;
    }

    private int _getClosestParentLineNumber(DetailAST firstNameDetailAST, int lineNumber) {
        int closestLineNumber = firstNameDetailAST.getLineNo();
        DetailAST parentDetailAST = firstNameDetailAST.getParent();
        while (parentDetailAST.getLineNo() > lineNumber) {
            closestLineNumber = parentDetailAST.getLineNo();
            parentDetailAST = parentDetailAST.getParent();
        }
        return closestLineNumber;
    }

    private DetailAST _getFirstDependentIdentDetailAST(String variableName, List<String> identValues, List<DetailAST> identDetailASTList) {
        for (DetailAST identDetailAST : identDetailASTList) {
            String methodName;
            DetailAST nextSiblingDetailAST;
            DetailAST grandParentDetailAST;
            String curName = identDetailAST.getText();
            if (curName.equals(variableName)) {
                return identDetailAST;
            }
            if (curName.equals("actionRequest") || curName.equals("portletRequest") || curName.equals("resourceRequest") || !identValues.contains(curName)) continue;
            DetailAST parentDetailAST = identDetailAST.getParent();
            if (parentDetailAST.getType() != 59) {
                return identDetailAST;
            }
            if (identDetailAST.getPreviousSibling() != null || (grandParentDetailAST = parentDetailAST.getParent()).getType() == 27 && (nextSiblingDetailAST = identDetailAST.getNextSibling()).getType() == 58 && (methodName = nextSiblingDetailAST.getText()).matches("get[A-Z].*")) continue;
            return identDetailAST;
        }
        return null;
    }

    private List<DetailAST> _getIdentDetailASTList(DetailAST variableDefinitionDetailAST) {
        ArrayList<DetailAST> identDetailASTList = new ArrayList<DetailAST>();
        DetailAST nextSiblingDetailAST = variableDefinitionDetailAST.getNextSibling();
        while (nextSiblingDetailAST != null) {
            identDetailASTList.addAll(DetailASTUtil.getAllChildTokens(nextSiblingDetailAST, true, 58));
            nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling();
        }
        return identDetailASTList;
    }

    private List<String> _getIdentValues(DetailAST variableDefinitionDetailAST) {
        ArrayList<String> identValues = new ArrayList<String>();
        List<DetailAST> identDetailASTList = DetailASTUtil.getAllChildTokens(variableDefinitionDetailAST, true, 58);
        for (DetailAST identDetailAST : identDetailASTList) {
            String identValue = identDetailAST.getText();
            if (Character.isUpperCase(identValue.charAt(0))) continue;
            identValues.add(identValue);
        }
        return identValues;
    }

    private DetailAST _getLastBranchingStatementDetailAST(DetailAST detailAST, int start, int end) {
        DetailAST lastBranchingStatementDetailAST = null;
        List<DetailAST> branchingStatementDetailASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 86, 87, 88);
        for (DetailAST branchingStatementDetailAST : branchingStatementDetailASTList) {
            int lineNumber = DetailASTUtil.getEndLineNumber(branchingStatementDetailAST);
            if (start >= lineNumber || end <= lineNumber) continue;
            DetailAST branchedStatementDetailAST = null;
            branchedStatementDetailAST = branchingStatementDetailAST.getType() == 86 || branchingStatementDetailAST.getType() == 87 ? DetailASTUtil.getParentWithTokenType(branchingStatementDetailAST, 85, 91, 84) : DetailASTUtil.getParentWithTokenType(branchingStatementDetailAST, 8, 181, 9);
            if (branchedStatementDetailAST == null || branchedStatementDetailAST.getLineNo() >= start || lastBranchingStatementDetailAST != null && branchingStatementDetailAST.getLineNo() <= lastBranchingStatementDetailAST.getLineNo()) continue;
            lastBranchingStatementDetailAST = branchingStatementDetailAST;
        }
        return lastBranchingStatementDetailAST;
    }
}

