/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesLiferayPluginPackageLiferayVersionsCheck
extends BaseFileCheck {
    private static final String _PORTAL_KERNEL_RELEASE_INFO_JAVA_FILE_NAME = "portal-kernel/src/com/liferay/portal/kernel/util/ReleaseInfo.java";
    private static final Pattern _liferayVersionsPattern = Pattern.compile("\nliferay-versions=(.*)\n");
    private static final Pattern _portalKernelReleaseInfoVersionPattern = Pattern.compile("private static final String _VERSION = \"(.*)\";");
    private static final Pattern _portalVersionPattern = Pattern.compile("(\\w+\\.\\w+)\\.\\w+");
    private static final Pattern _privateBranchNamePattern = Pattern.compile("private.branch.name=(.*)\n");
    private String _privatePortalVersion;
    private String _publicPortalVersion;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (fileName.endsWith("/liferay-plugin-package.properties")) {
            return this._fixIncorrectLiferayVersions(absolutePath, content);
        }
        return content;
    }

    private String _fixIncorrectLiferayVersions(String absolutePath, String content) throws IOException {
        if (!this.isPortalSource() || !this.isModulesApp(absolutePath, false)) {
            return content;
        }
        Matcher matcher = _liferayVersionsPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        boolean privateApp = this.isModulesApp(absolutePath, true);
        String portalVersion = this._getPortalVersion(privateApp);
        if (Validator.isNull(portalVersion)) {
            return content;
        }
        return StringUtil.replace(content, "liferay-versions=" + matcher.group(1), "liferay-versions=" + portalVersion + "+", matcher.start());
    }

    private String _getPortalVersion(boolean privateApp) throws IOException {
        String portalVersion = this._getPublicPortalVersion();
        if (privateApp) {
            portalVersion = this._getPrivatePortalVersion();
        }
        if (Validator.isNull(portalVersion) || privateApp) {
            return portalVersion;
        }
        Matcher matcher = _portalVersionPattern.matcher(portalVersion);
        if (matcher.find()) {
            portalVersion = matcher.group(1) + ".0";
        }
        return portalVersion;
    }

    private synchronized String _getPrivatePortalVersion() throws IOException {
        if (this._privatePortalVersion != null) {
            return this._privatePortalVersion;
        }
        this._privatePortalVersion = "";
        if (!this.isPortalSource()) {
            return this._privatePortalVersion;
        }
        File workingDirPropertiesFile = new File(this.getPortalDir(), "working.dir.properties");
        if (!workingDirPropertiesFile.exists()) {
            return this._privatePortalVersion;
        }
        String content = FileUtil.read(workingDirPropertiesFile);
        Matcher matcher = _privateBranchNamePattern.matcher(content);
        if (!matcher.find()) {
            return this._privatePortalVersion;
        }
        String privateBranchName = StringUtil.trim(matcher.group(1));
        if (Validator.isNull(privateBranchName)) {
            return this._privatePortalVersion;
        }
        String s = Pattern.quote("lp.version[" + privateBranchName + "]=");
        Pattern pattern = Pattern.compile(s + "(.*)");
        matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return this._privatePortalVersion;
        }
        this._privatePortalVersion = StringUtil.trim(matcher.group(1));
        return this._privatePortalVersion;
    }

    private synchronized String _getPublicPortalVersion() throws IOException {
        if (this._publicPortalVersion != null) {
            return this._publicPortalVersion;
        }
        this._publicPortalVersion = "";
        if (!this.isPortalSource()) {
            return this._publicPortalVersion;
        }
        File workingDirPropertiesFile = new File(this.getPortalDir(), "working.dir.properties");
        if (workingDirPropertiesFile.exists()) {
            String privateBranchName;
            String content = FileUtil.read(workingDirPropertiesFile);
            Matcher matcher = _privateBranchNamePattern.matcher(content);
            if (matcher.find() && Validator.isNotNull(privateBranchName = StringUtil.trim(matcher.group(1))) && privateBranchName.endsWith("-private")) {
                String branchName = StringUtil.replaceLast(privateBranchName, "-private", "");
                String s = Pattern.quote("lp.version[" + branchName + "]=");
                Pattern pattern = Pattern.compile(s + "(.*)");
                matcher = pattern.matcher(content);
                if (matcher.find()) {
                    String match = matcher.group(1);
                    this._publicPortalVersion = StringUtil.trim(match);
                }
            }
        } else {
            String content;
            Matcher matcher;
            File releaseInfoJavaFile = new File(this.getPortalDir(), _PORTAL_KERNEL_RELEASE_INFO_JAVA_FILE_NAME);
            if (releaseInfoJavaFile.exists() && (matcher = _portalKernelReleaseInfoVersionPattern.matcher(content = FileUtil.read(releaseInfoJavaFile))).find()) {
                this._publicPortalVersion = StringUtil.trim(matcher.group(1));
            }
        }
        return this._publicPortalVersion;
    }
}

