/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSONPropertyOrderCheck
extends BaseFileCheck {
    private static final Pattern _incorrectLineBreakPattern = Pattern.compile("\t[\\}\\]]{2}");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = _incorrectLineBreakPattern.matcher(content);
        if (matcher.find()) {
            this.addMessage(fileName, "There should be a line break after '}'", this.getLineNumber(content, matcher.start()));
            return content;
        }
        return this._sortProperties(content);
    }

    private String _mergeProperties(List<String> properties) {
        StringBundler sb = new StringBundler(2 * properties.size());
        for (String property : properties) {
            sb.append(property);
            sb.append(",\n");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    private String _sortProperties(String content) {
        Pattern pattern1;
        Matcher matcher1;
        String tabs = "";
        while ((matcher1 = (pattern1 = Pattern.compile("(\n|^)" + tabs + "[^\n\t]*[\\{\\[]\n")).matcher(content)).find()) {
            Pattern pattern2 = Pattern.compile(StringBundler.concat("((\n|^)", tabs, "[^\n\t]*[\\{\\[]((?=\n\t[\\}\\]])|\n", tabs, "\t[^\n\t][\\s\\S]*?))\n", tabs, "[\\}\\]]"));
            Matcher matcher2 = pattern2.matcher(content);
            while (matcher2.find()) {
                Pattern pattern3 = Pattern.compile(StringBundler.concat("(", tabs, "\t[^\n\t]*?([^\\{\\[]|([\\{\\[]((?=\n\t[\\}\\]])|[\\s\\S]*?)\n", tabs, "\t[\\}\\]]))),?(\n|$)"));
                String match = matcher2.group(1);
                Matcher matcher3 = pattern3.matcher(match);
                ArrayList<String> properties = new ArrayList<String>();
                StringBundler sb = new StringBundler();
                while (matcher3.find()) {
                    sb.append(matcher3.group());
                    String s = StringUtil.trimTrailing(matcher3.group());
                    if (s.endsWith(",")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    properties.add(s);
                }
                if (properties.isEmpty()) continue;
                Collections.sort(properties, new NaturalOrderStringComparator());
                content = StringUtil.replace(content, sb.toString(), this._mergeProperties(properties));
            }
            tabs = tabs + "\t";
        }
        return content;
    }
}

