/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDExportsCheck
extends BaseFileCheck {
    private static final String _ALLOWED_EXPORT_PACKAGE_DIR_NAMES_KEY = "allowedExportPackageDirNames";
    private static final Pattern _apiOrServiceBundleSymbolicNamePattern = Pattern.compile("\\.(api|service)$");
    private static final Pattern _exportContentsPattern = Pattern.compile("\n-exportcontents:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private static final Pattern _exportsPattern = Pattern.compile("\nExport-Package:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);

    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!fileName.endsWith("/bnd.bnd") || absolutePath.contains("/third-party/")) {
            return content;
        }
        if (!absolutePath.contains("/testIntegration/")) {
            this._checkExports(fileName, content, _exportContentsPattern, "-exportcontents");
            this._checkExports(fileName, content, _exportsPattern, "Export-Package");
        }
        if (absolutePath.contains("/modules/apps/")) {
            this._checkAllowedExportPackages(fileName, absolutePath, content);
        }
        this._checkExportPackages(fileName, content);
        return content;
    }

    private void _checkAllowedExportPackages(String fileName, String absolutePath, String content) {
        List<String> allowedExportPackageDirNames = this.getAttributeValues(_ALLOWED_EXPORT_PACKAGE_DIR_NAMES_KEY, absolutePath);
        for (String allowedExportPackageDirName : allowedExportPackageDirNames) {
            if (!absolutePath.contains(allowedExportPackageDirName)) continue;
            return;
        }
        if (fileName.endsWith("/test-bnd.bnd") || absolutePath.contains("-api/") || absolutePath.contains("-client/") || absolutePath.contains("-spi/") || absolutePath.contains("-taglib/") || absolutePath.contains("-test-util/") || !content.contains("Export-Package")) {
            return;
        }
        int x = absolutePath.lastIndexOf("/");
        int y = absolutePath.lastIndexOf("/", x - 1);
        this.addMessage(fileName, "Exporting packages not allowed in module '" + absolutePath.substring(y + 1, x) + "'", "bnd_exports.markdown");
    }

    private void _checkExportPackages(String fileName, String content) throws IOException {
        List<String> exportPackages = this._getExportPackages(content);
        if (exportPackages.isEmpty()) {
            return;
        }
        int i = fileName.lastIndexOf("/");
        String srcMainDirLocation = fileName.substring(0, i) + "/src/main/";
        File srcMainDir = new File(srcMainDirLocation);
        if (!srcMainDir.exists()) {
            return;
        }
        for (String exportPackage : exportPackages) {
            File importedFilesPropertiesFile;
            String exportPackagePath = StringUtil.replace(exportPackage, '.', '/');
            File resourcesDir = new File(StringBundler.concat(srcMainDirLocation, "resources/", exportPackagePath));
            Object[] resourcesFiles = resourcesDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String fileName = pathname.getName();
                    if (fileName.startsWith(".lfrbuild-") || fileName.equals("packageinfo")) {
                        return false;
                    }
                    return pathname.isFile();
                }
            });
            File srcDir = new File(StringBundler.concat(srcMainDirLocation, "java/", exportPackagePath));
            Object[] srcFiles = srcDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile();
                }
            });
            File packageinfoFile = new File(StringBundler.concat(srcMainDirLocation, "resources/", exportPackagePath, "/packageinfo"));
            if (ArrayUtil.isNotEmpty(resourcesFiles) || ArrayUtil.isNotEmpty(srcFiles)) {
                if (packageinfoFile.exists()) continue;
                this.addMessage(fileName, "Added packageinfo for " + exportPackage);
                FileUtil.write(packageinfoFile, "version 1.0.0");
                continue;
            }
            if (!exportPackage.startsWith("com.liferay.") || (importedFilesPropertiesFile = new File(fileName.substring(0, i) + "/imported-files.properties")).exists()) continue;
            this.addMessage(fileName, "Unneeded/incorrect Export-Package: " + exportPackage);
        }
    }

    private void _checkExports(String fileName, String content, Pattern pattern, String definitionKey) {
        String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(content, "Bundle-SymbolicName");
        if (bundleSymbolicName == null || bundleSymbolicName.endsWith(".compat")) {
            return;
        }
        Matcher matcher = _apiOrServiceBundleSymbolicNamePattern.matcher(bundleSymbolicName);
        bundleSymbolicName = matcher.replaceAll("");
        matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return;
        }
        String[] lines = StringUtil.splitLines(matcher.group(2));
        for (int i = 0; i < lines.length; ++i) {
            String line = StringUtil.removeChar(StringUtil.trim(lines[i]), '\\');
            if (Validator.isNull(line) || !line.startsWith("com.liferay.") || line.startsWith(bundleSymbolicName)) continue;
            StringBundler sb = new StringBundler(6);
            sb.append(definitionKey);
            sb.append(" '");
            sb.append(line);
            sb.append("' should match Bundle-SymbolicName '");
            sb.append(bundleSymbolicName);
            sb.append("'");
            this.addMessage(fileName, sb.toString(), this.getLineNumber(content, matcher.start(2)) + i);
        }
    }

    private List<String> _getExportPackages(String content) {
        Matcher matcher = _exportsPattern.matcher(content);
        if (!matcher.find()) {
            return Collections.emptyList();
        }
        ArrayList<String> exportPackages = new ArrayList<String>();
        for (String line : StringUtil.splitLines(matcher.group(3))) {
            if (Validator.isNull(line = StringUtil.trim(line)) || line.equals("\\")) continue;
            if ((line = StringUtil.removeSubstring(line, ",\\")).indexOf(";") != -1) {
                line = line.substring(0, line.indexOf(";"));
            }
            exportPackages.add(line);
        }
        return exportPackages;
    }
}

