/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.tools.ImportPackage;
import java.io.IOException;
import java.util.TreeSet;

public abstract class ImportsFormatter {
    public String format(String imports) throws IOException {
        if (imports.contains("/*") || imports.contains("*/") || imports.contains("\n//")) {
            return imports + "\n";
        }
        TreeSet<ImportPackage> importPackages = new TreeSet<ImportPackage>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(imports));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            ImportPackage importPackage = this.createImportPackage(line);
            if (importPackage == null) continue;
            importPackages.add(importPackage);
        }
        StringBundler sb = new StringBundler(3 * importPackages.size());
        ImportPackage previousImportPackage = null;
        for (ImportPackage importPackage : importPackages) {
            if (previousImportPackage != null && !importPackage.isGroupedWith(previousImportPackage)) {
                sb.append("\n");
            }
            sb.append(importPackage.getLine());
            sb.append("\n");
            previousImportPackage = importPackage;
        }
        return sb.toString();
    }

    protected abstract ImportPackage createImportPackage(String var1);
}

