/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.util;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.util.CheckType;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.TreeSet;

public class CheckstyleLogger
extends DefaultLogger {
    private static final Set<SourceFormatterMessage> _sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
    private final String _baseDirName;

    public CheckstyleLogger(String baseDirName) {
        super((OutputStream)new UnsyncByteArrayOutputStream(), AutomaticBean.OutputStreamOptions.CLOSE);
        this._baseDirName = baseDirName;
        _sourceFormatterMessages.clear();
    }

    public void addError(AuditEvent auditEvent) {
        this.addError(auditEvent, this.getRelativizedFileName(auditEvent));
    }

    public Set<SourceFormatterMessage> getSourceFormatterMessages() {
        return _sourceFormatterMessages;
    }

    protected void addError(AuditEvent auditEvent, String fileName) {
        String checkName = SourceFormatterUtil.getSimpleName(auditEvent.getSourceName());
        _sourceFormatterMessages.add(new SourceFormatterMessage(fileName, auditEvent.getMessage(), CheckType.CHECKSTYLE, checkName, null, auditEvent.getLine()));
        super.addError(auditEvent);
    }

    protected String getRelativizedFileName(AuditEvent auditEvent) {
        if (Validator.isNull(this._baseDirName)) {
            return auditEvent.getFileName();
        }
        Path baseDirPath = this._getAbsoluteNormalizedPath(this._baseDirName);
        Path relativizedPath = baseDirPath.relativize(this._getAbsoluteNormalizedPath(auditEvent.getFileName()));
        String relativizedPathString = StringUtil.replace(relativizedPath.toString(), '\\', '/');
        return this._baseDirName + relativizedPathString;
    }

    private Path _getAbsoluteNormalizedPath(String pathName) {
        Path path = Paths.get(pathName, new String[0]);
        path = path.toAbsolutePath();
        return path.normalize();
    }
}

