/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.PoshiSourceUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiParametersOrderCheck
extends BaseFileCheck {
    private static final Pattern _methodCallPattern = Pattern.compile(StringBundler.concat("(?:[^>])\n([ \t]*\\w+(?:\\.\\w+)?\\(", "((\\s*\\w+[ \t]*=[ \t]*(('''|\").*?\\5|\\w[^\n]*\\))\\s*)", "(,(\\s*\\w+[ \t]*=[ \t]*(('''|\").*?\\9|\\w[^\n]*\\))\\s*))*))", "(?=\\)\\s*;\n)"), 32);
    private static final Pattern _multiLineCommentsPattern = Pattern.compile("[ \t]/\\*.*?\\*/", 32);
    private static final Pattern _parametersPattern = Pattern.compile("(\\w+)([ \t]*=[ \t]*)((('''|\").*?\\5|\\w[^\n]*\\))|.+?\\))", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        return this._sortPoshiParameters(fileName, content);
    }

    private String _sortPoshiParameters(String fileName, String content) {
        Matcher matcher1 = _methodCallPattern.matcher(content);
        block0: while (matcher1.find()) {
            TreeMap<String, String> parametersMap = new TreeMap<String, String>(new NaturalOrderStringComparator());
            String parameters = matcher1.group(2);
            Matcher matcher2 = _parametersPattern.matcher(parameters);
            while (matcher2.find()) {
                String parameterName = matcher2.group(1);
                if (parametersMap.containsKey(parameterName)) {
                    this.addMessage(fileName, "Duplicate parameter '" + parameterName + "'", this.getLineNumber(content, matcher1.start(1)));
                    continue block0;
                }
                parametersMap.put(parameterName, matcher2.group(3));
            }
            if (parametersMap.isEmpty()) continue;
            StringBundler sb = new StringBundler(parametersMap.size() * 7);
            String indent = SourceUtil.getIndent(matcher1.group(1));
            for (Map.Entry entry : parametersMap.entrySet()) {
                if (parametersMap.size() == 1) {
                    sb.append((String)entry.getKey());
                    sb.append(" = ");
                    sb.append((String)entry.getValue());
                    break;
                }
                sb.append('\n');
                sb.append(indent);
                sb.append('\t');
                sb.append((String)entry.getKey());
                sb.append(" = ");
                sb.append((String)entry.getValue());
                sb.append(',');
            }
            if (parametersMap.size() > 1) {
                sb.setIndex(sb.index() - 1);
            }
            int x = content.indexOf(parameters);
            int[] multiLineCommentsPositions = PoshiSourceUtil.getMultiLinePositions(content, _multiLineCommentsPattern);
            while (content.indexOf(parameters, x) != -1 && PoshiSourceUtil.isInsideMultiLines(SourceUtil.getLineNumber(content, x), multiLineCommentsPositions)) {
                x += parameters.length();
            }
            if (content.indexOf(parameters, x) == -1) continue;
            content = StringUtil.replaceFirst(content, parameters, sb.toString(), x);
        }
        return content;
    }
}

