/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.WhitespaceCheck;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSONWhitespaceCheck
extends WhitespaceCheck {
    private static final Pattern _leadingSpacesPattern = Pattern.compile("(^[\t ]*)(  )([^ ])");
    private static final Pattern _missingWhitespacePattern = Pattern.compile(":\\S");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                Matcher matcher;
                while ((matcher = _leadingSpacesPattern.matcher(line)).find()) {
                    line = matcher.replaceAll("$1\t$3");
                }
                line = StringUtil.replace(line, "  ", " ");
                if (line.startsWith(" \t")) {
                    line = line.replaceFirst(" \t", "\t");
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        if (this.isAllowTrailingEmptyLines(fileName, absolutePath) && content.endsWith("\n")) {
            content = sb.toString();
        } else {
            content = sb.toString();
            if (content.endsWith("\n")) {
                content = content.substring(0, content.length() - 1);
            }
        }
        Matcher matcher = _missingWhitespacePattern.matcher(content);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(content, matcher.start())) continue;
            return StringUtil.insert(content, " ", matcher.start() + 1);
        }
        return super.doProcess(fileName, absolutePath, content);
    }

    @Override
    protected boolean isAllowTrailingEmptyLines(String fileName, String absolutePath) {
        return fileName.endsWith("/package.json");
    }
}

