/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.java.parser;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.tools.java.parser.JavaExpression;
import com.liferay.portal.tools.java.parser.JavaSimpleValue;
import com.liferay.portal.tools.java.parser.JavaType;
import java.util.List;

public class JavaMethodReference
extends JavaExpression {
    private final List<JavaType> _genericJavaTypes;
    private final JavaSimpleValue _methodName;
    private final JavaExpression _referenceJavaExpression;

    public JavaMethodReference(String methodName, JavaExpression referenceJavaExpression, List<JavaType> genericJavaTypes) {
        this._methodName = new JavaSimpleValue(methodName);
        this._referenceJavaExpression = referenceJavaExpression;
        this._genericJavaTypes = genericJavaTypes;
    }

    @Override
    protected String getString(String indent, String prefix, String suffix, int maxLineLength, boolean forceLineBreak) {
        StringBundler sb = new StringBundler();
        sb.append(indent);
        indent = "\t" + indent;
        sb.append(prefix);
        if (this._genericJavaTypes != null) {
            this.append(sb, this._referenceJavaExpression, indent, maxLineLength);
            this.append(sb, this._genericJavaTypes, indent, "<", ">::", maxLineLength);
        } else {
            this.append(sb, this._referenceJavaExpression, indent, "", "::", maxLineLength);
        }
        this.append(sb, this._methodName, indent, "", suffix, maxLineLength);
        return sb.toString();
    }
}

