/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.java.parser;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.tools.java.parser.JavaExpression;
import com.liferay.portal.tools.java.parser.JavaSimpleValue;
import com.liferay.portal.tools.java.parser.JavaType;
import java.util.List;

public class JavaClassCall
extends JavaExpression {
    protected static final String NESTED_CODE_BLOCK = "${JAVA_CLASS_CALL_NESTED_CODE_BLOCK}";
    private final JavaSimpleValue _className;
    private boolean _emptyBody;
    private final List<JavaType> _genericJavaTypes;
    private boolean _hasBody;
    private final List<JavaExpression> _parameterValueJavaExpressions;
    private boolean _statementCondition;
    private boolean _useChainStyle;

    public JavaClassCall(String className, List<JavaType> genericJavaTypes, List<JavaExpression> parameterValueJavaExpressions) {
        this._className = new JavaSimpleValue(className);
        this._genericJavaTypes = genericJavaTypes;
        this._parameterValueJavaExpressions = parameterValueJavaExpressions;
    }

    public boolean hasBody() {
        return this._hasBody;
    }

    public boolean hasParameterValueJavaExpressions() {
        return !this._parameterValueJavaExpressions.isEmpty();
    }

    public void setEmptyBody(boolean emptyBody) {
        this._emptyBody = emptyBody;
    }

    public void setHasBody(boolean hasBody) {
        this._hasBody = hasBody;
    }

    public void setStatementCondition(boolean statementCondition) {
        this._statementCondition = statementCondition;
    }

    public void setUseChainStyle(boolean useChainStyle) {
        this._useChainStyle = useChainStyle;
    }

    @Override
    protected String getString(String indent, String prefix, String suffix, int maxLineLength, boolean forceLineBreak) {
        String originalIndent = indent;
        String originalSuffix = suffix;
        if (this._hasBody) {
            suffix = " {";
        }
        StringBundler sb = new StringBundler();
        sb.append(indent);
        indent = "\t" + indent;
        if (this._genericJavaTypes == null) {
            if (this._parameterValueJavaExpressions.isEmpty()) {
                this.append(sb, this._className, indent, prefix, "()" + suffix, maxLineLength);
            } else {
                indent = this.append(sb, this._className, indent, prefix, "(", maxLineLength);
            }
        } else {
            indent = this.append(sb, this._className, indent, prefix, "", maxLineLength);
            if (this._parameterValueJavaExpressions.isEmpty()) {
                this.append(sb, this._genericJavaTypes, indent, "<", ">()" + suffix, maxLineLength);
            } else {
                indent = this.append(sb, this._genericJavaTypes, indent, "<", ">(", maxLineLength);
            }
        }
        if (!this._parameterValueJavaExpressions.isEmpty()) {
            if (!this._statementCondition && this._useChainStyle) {
                this.appendNewLine(sb, this._parameterValueJavaExpressions, indent, maxLineLength);
                sb.append("\n");
                if (prefix.startsWith("try (")) {
                    sb.append("\t");
                }
                sb.append(originalIndent);
                sb.append(")");
                sb.append(suffix);
            } else if (forceLineBreak && !this._hasBody) {
                this.appendNewLine(sb, this._parameterValueJavaExpressions, indent, "", ")" + suffix, maxLineLength);
            } else {
                this.append(sb, this._parameterValueJavaExpressions, indent, "", ")" + suffix, maxLineLength);
            }
        }
        if (this._hasBody) {
            sb.append("\n");
            if (!this._emptyBody) {
                sb.append(NESTED_CODE_BLOCK);
                sb.append("\n");
            }
            sb.append(originalIndent);
            if (prefix.startsWith("try (")) {
                sb.append("\t");
            }
            sb.append("}");
            sb.append(originalSuffix);
        }
        return sb.toString();
    }
}

