/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.log;

import com.liferay.portal.kernel.log.Jdk14LogFactoryImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogWrapper;
import com.liferay.portal.kernel.log.SanitizerLogWrapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LogFactoryUtil {
    private static volatile LogFactory _logFactory = new Jdk14LogFactoryImpl();
    private static final ConcurrentMap<String, LogWrapper> _logWrappers = new ConcurrentHashMap<String, LogWrapper>();

    public static Log getLog(Class<?> c) {
        return LogFactoryUtil.getLog(c.getName());
    }

    public static Log getLog(String name) {
        LogWrapper previousLogWrapper;
        LogWrapper logWrapper = (LogWrapper)_logWrappers.get(name);
        if (logWrapper == null && (previousLogWrapper = _logWrappers.putIfAbsent(name, logWrapper = SanitizerLogWrapper.isEnabled() ? new SanitizerLogWrapper(_logFactory.getLog(name)) : new LogWrapper(_logFactory.getLog(name)))) != null) {
            logWrapper = previousLogWrapper;
        }
        return logWrapper;
    }

    public static LogFactory getLogFactory() {
        return _logFactory;
    }

    public static void setLogFactory(LogFactory logFactory) {
        for (Map.Entry entry : _logWrappers.entrySet()) {
            String name = (String)entry.getKey();
            LogWrapper logWrapper = (LogWrapper)entry.getValue();
            logWrapper.setLog(logFactory.getLog(name));
        }
        _logFactory = logFactory;
    }
}

