/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class PropertiesSourceFormatterFileCheck
extends BaseFileCheck {
    private Boolean _hasPrivateAppsDir;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (fileName.endsWith("/source-formatter.properties")) {
            this._checkSourceFormatterProperties(fileName);
        }
        return content;
    }

    private void _checkSourceFormatterProperties(String fileName) throws IOException {
        int level = 3;
        if (this.isPortalSource()) {
            level = 7;
        }
        Properties properties = new Properties();
        FileInputStream inputStream = new FileInputStream(fileName);
        properties.load(inputStream);
        Enumeration<?> enu = properties.propertyNames();
        while (enu.hasMoreElements()) {
            String value;
            String key = (String)enu.nextElement();
            if (!key.endsWith("excludes") || Validator.isNull(value = properties.getProperty(key))) continue;
            List<String> propertyFileNames = ListUtil.fromString(value, ",");
            for (String propertyFileName : propertyFileNames) {
                File file;
                if (propertyFileName.contains("*") || propertyFileName.endsWith("-ext.properties") || this.isPortalSource() && !this._hasPrivateAppsDir() && this.isModulesApp(propertyFileName, true)) continue;
                int pos = propertyFileName.indexOf(64);
                if (pos != -1) {
                    propertyFileName = propertyFileName.substring(0, pos);
                }
                if ((file = this.getFile(propertyFileName, level)) != null) continue;
                this.addMessage(fileName, "Property value '" + propertyFileName + "' points to file that does not exist");
            }
        }
    }

    private synchronized boolean _hasPrivateAppsDir() {
        if (this._hasPrivateAppsDir != null) {
            return this._hasPrivateAppsDir;
        }
        this._hasPrivateAppsDir = false;
        if (this.isPortalSource()) {
            return this._hasPrivateAppsDir;
        }
        File privateAppsDir = this.getFile("modules/private/apps", 7);
        if (privateAppsDir != null) {
            this._hasPrivateAppsDir = true;
        }
        return this._hasPrivateAppsDir;
    }
}

