/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.WhitespaceCheck;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiWhitespaceCheck
extends WhitespaceCheck {
    private static final Pattern _incorrectWhitespacePattern = Pattern.compile("\\)(\\s+);");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        content = this._formatWhitespace(content);
        return super.doProcess(fileName, absolutePath, content);
    }

    private String _formatWhitespace(String content) {
        Matcher matcher = _incorrectWhitespacePattern.matcher(content);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(content, matcher.start(1))) continue;
            return StringUtil.replaceFirst(content, matcher.group(1), "", matcher.start());
        }
        return content;
    }
}

