/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaServiceTrackerFactoryCheck
extends BaseFileCheck {
    private static final Pattern _serviceTrackerFactoryOpenPattern = Pattern.compile("\\WServiceTrackerFactory\\.\\s*open\\(");

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = _serviceTrackerFactoryOpenPattern.matcher(content);
        while (matcher.find()) {
            List<String> parameterList;
            if (ToolsUtil.isInsideQuotes(content, matcher.end()) || (parameterList = JavaSourceUtil.getParameterList(content.substring(matcher.start()))).size() != 1) continue;
            this.addMessage(fileName, "ServiceTrackerFactory.open(Class clazz) is deprecated since it leaks ServiceTrackers, see LPS-95067", this.getLineNumber(content, matcher.start()));
        }
        return content;
    }
}

