/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import aQute.bnd.version.Version;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleDependencyVersionCheck
extends BaseFileCheck {
    private static final String _MODULES_PROPERTIES_FILE_NAME = "modules/modules.properties";
    private static final Pattern _dependenciesPattern = Pattern.compile("(\n|\\A)(\t*)dependencies \\{\n");
    private static final Pattern _dependencyNamePattern = Pattern.compile(".*, name: \"([^\"]*)\".*");
    private static final Pattern _dependencyVersionPattern = Pattern.compile(".*, version: \"([^\"]*)\".*");
    private static final Pattern _majorVersionPattern = Pattern.compile("^[0-9]+");
    private final List<String> _enforceConsistentVersionDependencyNames = new ArrayList<String>();
    private Map<String, Version> _latestVersionsMap;
    private Map<String, Integer> _publishedMajorVersionsMap;

    public void setEnforceConsistentVersionDependencyNames(String enforceConsistentVersionDependencyNames) {
        Collections.addAll(this._enforceConsistentVersionDependencyNames, StringUtil.split(enforceConsistentVersionDependencyNames));
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (absolutePath.contains("/modules/apps/")) {
            content = this._formatInconsistentVersions(content);
        }
        if (this.isExcludedPath("run.outside.portal.excludes", absolutePath)) {
            return content;
        }
        int x = absolutePath.lastIndexOf("/");
        int y = absolutePath.lastIndexOf("/", x - 1);
        String moduleName = absolutePath.substring(y + 1, x);
        if (!moduleName.contains("test")) {
            for (String dependencies : this._getDependenciesBlocks(content)) {
                content = this._formatDependencies(content, dependencies);
            }
        }
        return content;
    }

    private String _formatDependencies(String content, String dependencies) throws IOException {
        int y;
        int x = dependencies.indexOf("\n");
        if (x == (y = dependencies.lastIndexOf("\n"))) {
            return content;
        }
        dependencies = dependencies.substring(x, y + 1);
        StringBundler sb = new StringBundler();
        for (String line : StringUtil.splitLines(dependencies)) {
            String dependencyName = this._getDependencyName(line);
            if (Objects.isNull(dependencyName) || line.matches(".*\\s+testCompile\\s+.*")) {
                sb.append(line);
                sb.append("\n");
                continue;
            }
            String dependencyVersion = this._getDependencyVersion(line);
            if (dependencyVersion.matches("^[0-9.]+") && !this._isValidVersion(dependencyName, dependencyVersion)) {
                Map<String, Integer> publishedMajorVersionsMap = this._getPublishedMajorVersionsMap();
                line = StringUtil.replaceFirst(line, dependencyVersion, publishedMajorVersionsMap.get(dependencyName) + ".0.0");
            }
            sb.append(line);
            sb.append("\n");
        }
        return StringUtil.replace(content, StringUtil.trim(dependencies), StringUtil.trim(sb.toString()));
    }

    private String _formatInconsistentVersions(String content) throws IOException {
        Map<String, Version> latestVersionsMap = this._getLatestVersionsMap();
        if (latestVersionsMap.isEmpty()) {
            return content;
        }
        for (String dependencyName : this._enforceConsistentVersionDependencyNames) {
            String version;
            Pattern pattern;
            Matcher matcher;
            Version latestVersion = latestVersionsMap.get(dependencyName);
            if (latestVersion == null || !(matcher = (pattern = Pattern.compile("compileOnly .*, name: \"" + dependencyName + "\",.* version: \"(.*?)\"")).matcher(content)).find() || (version = matcher.group(1)).equals(latestVersion.toString())) continue;
            return StringUtil.replaceFirst(content, version, latestVersion.toString(), matcher.start(1));
        }
        return content;
    }

    private List<String> _getBuildGradleFileNames() throws IOException {
        String modulesAppsDirLocation = "modules/apps/";
        for (int i = 0; i < 6; ++i) {
            File file = new File(this.getBaseDirName() + modulesAppsDirLocation);
            if (file.exists()) {
                return SourceFormatterUtil.scanForFiles(this.getBaseDirName() + modulesAppsDirLocation, new String[0], new String[]{"**/build.gradle"}, this.getSourceFormatterExcludes(), false);
            }
            modulesAppsDirLocation = "../" + modulesAppsDirLocation;
        }
        return null;
    }

    private List<String> _getDependenciesBlocks(String content) {
        ArrayList<String> dependenciesBlocks = new ArrayList<String>();
        Matcher matcher = _dependenciesPattern.matcher(content);
        while (matcher.find()) {
            String dependencies;
            int level;
            int y = matcher.start();
            do {
                if ((y = content.indexOf("}", y + 1)) != -1) continue;
                return dependenciesBlocks;
            } while ((level = this.getLevel(dependencies = content.substring(matcher.start(2), y + 1), "{", "}")) != 0);
            if (dependencies.contains("}\n")) continue;
            dependenciesBlocks.add(dependencies);
        }
        return dependenciesBlocks;
    }

    private String _getDependencyName(String dependency) {
        Matcher matcher = _dependencyNamePattern.matcher(dependency);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(1);
    }

    private String _getDependencyVersion(String dependency) {
        Matcher matcher = _dependencyVersionPattern.matcher(dependency);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(1);
    }

    private synchronized Map<String, Version> _getLatestVersionsMap() throws IOException {
        if (this._latestVersionsMap != null) {
            return this._latestVersionsMap;
        }
        this._latestVersionsMap = new HashMap<String, Version>();
        if (this._enforceConsistentVersionDependencyNames.isEmpty()) {
            return this._latestVersionsMap;
        }
        List<String> buildGradleFileNames = this._getBuildGradleFileNames();
        if (buildGradleFileNames == null) {
            return this._latestVersionsMap;
        }
        for (String buildGradleFileName : buildGradleFileNames) {
            String buildGradleFileContent = FileUtil.read(new File(buildGradleFileName));
            for (String dependencyName : this._enforceConsistentVersionDependencyNames) {
                Pattern pattern = Pattern.compile("compileOnly .*, name: \"" + dependencyName + "\",.* version: \"(.*?)\"");
                Matcher matcher = pattern.matcher(buildGradleFileContent);
                if (!matcher.find()) continue;
                Version latestVerion = this._latestVersionsMap.get(dependencyName);
                Version version = new Version(matcher.group(1));
                if (latestVerion != null && version.compareTo(latestVerion) <= 0) continue;
                this._latestVersionsMap.put(dependencyName, version);
            }
        }
        return this._latestVersionsMap;
    }

    private String _getMajorVersion(String version) {
        Matcher matcher = _majorVersionPattern.matcher(version);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group();
    }

    private String _getModulesPropertiesContent() throws IOException {
        if (!this.isPortalSource()) {
            return this.getPortalContent(_MODULES_PROPERTIES_FILE_NAME);
        }
        return this.getContent(_MODULES_PROPERTIES_FILE_NAME, 7);
    }

    private synchronized Map<String, Integer> _getPublishedMajorVersionsMap() throws IOException {
        if (this._publishedMajorVersionsMap != null) {
            return this._publishedMajorVersionsMap;
        }
        String content = this._getModulesPropertiesContent();
        if (Validator.isNull(content)) {
            this._publishedMajorVersionsMap = Collections.emptyMap();
            return this._publishedMajorVersionsMap;
        }
        HashMap<String, String> bundleVersionsMap = new HashMap<String, String>();
        List<String> lines = ListUtil.fromString(content);
        for (String string : lines) {
            String[] array = StringUtil.split(string, "=");
            if (array.length != 2) continue;
            bundleVersionsMap.put(array[0], array[1]);
        }
        this._publishedMajorVersionsMap = new HashMap<String, Integer>();
        for (Map.Entry entry : bundleVersionsMap.entrySet()) {
            String bundleVersion = (String)entry.getValue();
            String majorVersion = this._getMajorVersion(bundleVersion);
            if (Validator.isNull(majorVersion)) continue;
            int publishedMajorVersion = GetterUtil.getInteger(majorVersion);
            if (publishedMajorVersion > 1 && bundleVersion.matches(publishedMajorVersion + "[0.]*")) {
                --publishedMajorVersion;
            }
            this._publishedMajorVersionsMap.put((String)entry.getKey(), publishedMajorVersion);
        }
        return this._publishedMajorVersionsMap;
    }

    private boolean _isValidVersion(String dependencyName, String dependencyVersion) throws IOException {
        Map<String, Integer> publishedMajorVersionsMap = this._getPublishedMajorVersionsMap();
        Set<String> bundleSymbolicNames = publishedMajorVersionsMap.keySet();
        if (!dependencyName.startsWith("com.liferay.") || !bundleSymbolicNames.contains(dependencyName)) {
            return true;
        }
        return GetterUtil.getInteger(this._getMajorVersion(dependencyVersion)) == publishedMajorVersionsMap.get(dependencyName);
    }
}

