/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.EmptyLinesCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSSEmptyLinesCheck
extends EmptyLinesCheck {
    private static final Pattern _emptyLineAfterOpenCurlyBrace = Pattern.compile("\\{\n\n\t*(?!(/\\* --|//))\\S");
    private static final Pattern _emptyLineBeforeCloseCurlyBrace = Pattern.compile("\n\n\t*\\}");
    private static final Pattern _missingEmptyLineAfterComment = Pattern.compile("-- \\*/\n.");
    private static final Pattern _missingEmptyLineBeforeComment = Pattern.compile(".\n\t*/\\* --");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this.fixMissingEmptyLinesAroundComments(content);
        return this._fixEmptyLines(content);
    }

    private String _fixEmptyLines(String content) {
        Matcher matcher = _emptyLineAfterOpenCurlyBrace.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        matcher = _emptyLineBeforeCloseCurlyBrace.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        matcher = _missingEmptyLineAfterComment.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
        }
        matcher = _missingEmptyLineBeforeComment.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
        }
        return content;
    }
}

