/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SuppressWithPlainTextCommentFilter
extends AutomaticBean
implements Filter {
    private static final String DEFAULT_OFF_FORMAT = "// CHECKSTYLE:OFF";
    private static final String DEFAULT_ON_FORMAT = "// CHECKSTYLE:ON";
    private static final String DEFAULT_CHECK_FORMAT = ".*";
    private Pattern offCommentFormat = CommonUtil.createPattern("// CHECKSTYLE:OFF");
    private Pattern onCommentFormat = CommonUtil.createPattern("// CHECKSTYLE:ON");
    private String checkFormat = ".*";
    private String messageFormat;

    public final void setOffCommentFormat(Pattern pattern) {
        this.offCommentFormat = pattern;
    }

    public final void setOnCommentFormat(Pattern pattern) {
        this.onCommentFormat = pattern;
    }

    public final void setCheckFormat(String format) {
        this.checkFormat = format;
    }

    public final void setMessageFormat(String format) {
        this.messageFormat = format;
    }

    @Override
    public boolean accept(AuditEvent event) {
        FileText fileText;
        boolean accepted = true;
        if (event.getLocalizedMessage() != null && (fileText = SuppressWithPlainTextCommentFilter.getFileText(event.getFileName())) != null) {
            List<Suppression> suppressions = this.getSuppressions(fileText);
            accepted = SuppressWithPlainTextCommentFilter.getNearestSuppression(suppressions, event) == null;
        }
        return accepted;
    }

    @Override
    protected void finishLocalSetup() {
    }

    private static FileText getFileText(String fileName) {
        File file = new File(fileName);
        FileText result = null;
        if (!file.isDirectory()) {
            try {
                result = new FileText(file, StandardCharsets.UTF_8.name());
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot read source file: " + fileName, ex);
            }
        }
        return result;
    }

    private List<Suppression> getSuppressions(FileText fileText) {
        ArrayList<Suppression> suppressions = new ArrayList<Suppression>();
        for (int lineNo = 0; lineNo < fileText.size(); ++lineNo) {
            Optional<Suppression> suppression = this.getSuppression(fileText, lineNo);
            suppression.ifPresent(suppressions::add);
        }
        return suppressions;
    }

    private Optional<Suppression> getSuppression(FileText fileText, int lineNo) {
        String line = fileText.get(lineNo);
        Matcher onCommentMatcher = this.onCommentFormat.matcher(line);
        Matcher offCommentMatcher = this.offCommentFormat.matcher(line);
        Suppression suppression = null;
        if (onCommentMatcher.find()) {
            suppression = new Suppression(onCommentMatcher.group(0), lineNo + 1, onCommentMatcher.start(), SuppressionType.ON, this);
        }
        if (offCommentMatcher.find()) {
            suppression = new Suppression(offCommentMatcher.group(0), lineNo + 1, offCommentMatcher.start(), SuppressionType.OFF, this);
        }
        return Optional.ofNullable(suppression);
    }

    private static Suppression getNearestSuppression(List<Suppression> suppressions, AuditEvent event) {
        return suppressions.stream().filter(suppression -> ((Suppression)suppression).isMatch(event)).reduce((first, second) -> second).filter(suppression -> ((Suppression)suppression).suppressionType != SuppressionType.ON).orElse(null);
    }

    public static class Suppression {
        private final Pattern eventSourceRegexp;
        private final Pattern eventMessageRegexp;
        private final String text;
        private final int lineNo;
        private final int columnNo;
        private final SuppressionType suppressionType;

        protected Suppression(String text, int lineNo, int columnNo, SuppressionType suppressionType, SuppressWithPlainTextCommentFilter filter) {
            this.text = text;
            this.lineNo = lineNo;
            this.columnNo = columnNo;
            this.suppressionType = suppressionType;
            String format = "";
            try {
                if (this.suppressionType == SuppressionType.ON) {
                    format = CommonUtil.fillTemplateWithStringsByRegexp(filter.checkFormat, text, filter.onCommentFormat);
                    this.eventSourceRegexp = Pattern.compile(format);
                    if (filter.messageFormat == null) {
                        this.eventMessageRegexp = null;
                    } else {
                        format = CommonUtil.fillTemplateWithStringsByRegexp(filter.messageFormat, text, filter.onCommentFormat);
                        this.eventMessageRegexp = Pattern.compile(format);
                    }
                } else {
                    format = CommonUtil.fillTemplateWithStringsByRegexp(filter.checkFormat, text, filter.offCommentFormat);
                    this.eventSourceRegexp = Pattern.compile(format);
                    if (filter.messageFormat == null) {
                        this.eventMessageRegexp = null;
                    } else {
                        format = CommonUtil.fillTemplateWithStringsByRegexp(filter.messageFormat, text, filter.offCommentFormat);
                        this.eventMessageRegexp = Pattern.compile(format);
                    }
                }
            }
            catch (PatternSyntaxException ex) {
                throw new IllegalArgumentException("unable to parse expanded comment " + format, ex);
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Suppression suppression = (Suppression)other;
            return Objects.equals(this.lineNo, suppression.lineNo) && Objects.equals(this.columnNo, suppression.columnNo) && Objects.equals((Object)this.suppressionType, (Object)suppression.suppressionType) && Objects.equals(this.text, suppression.text) && Objects.equals(this.eventSourceRegexp, suppression.eventSourceRegexp) && Objects.equals(this.eventMessageRegexp, suppression.eventMessageRegexp);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.text, this.lineNo, this.columnNo, this.suppressionType, this.eventSourceRegexp, this.eventMessageRegexp});
        }

        private boolean isMatch(AuditEvent event) {
            boolean match = false;
            if (this.isInScopeOfSuppression(event)) {
                Matcher sourceNameMatcher = this.eventSourceRegexp.matcher(event.getSourceName());
                match = sourceNameMatcher.find() ? this.eventMessageRegexp == null || this.eventMessageRegexp.matcher(event.getMessage()).find() : event.getModuleId() != null && this.eventSourceRegexp.matcher(event.getModuleId()).find();
            }
            return match;
        }

        private boolean isInScopeOfSuppression(AuditEvent event) {
            return this.lineNo <= event.getLine();
        }
    }

    private static enum SuppressionType {
        ON,
        OFF;

    }
}

