/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.liferay.source.formatter.util.DebugUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConstantNameCheck
extends com.puppycrawl.tools.checkstyle.checks.naming.ConstantNameCheck {
    private static final String _CAMEL_CASE_REGEX = "^[a-z0-9][a-zA-Z0-9]*$";
    private static final String _CONSTANT_NAME_REGEX = "^[a-zA-Z0-9][_a-zA-Z0-9]*$";
    private static final String _MSG_INVALID_CONSTANT_NAME = "name.invalidConstantPattern";
    private static final String _MSG_INVALID_CONSTANT_TYPE_NAME = "name.invalidConstantTypePattern";
    private static final String _UPPER_CASE_REGEX = "^[A-Z0-9][_A-Z0-9]*$";
    private String[] _camelCaseTypeNames = new String[0];
    private boolean _enabled = true;
    private String[] _immutableFieldTypes = new String[0];
    private boolean _showDebugInformation;

    public void setCamelCaseTypeNames(String camelCaseTypeNames) {
        this._camelCaseTypeNames = ArrayUtil.append(this._camelCaseTypeNames, StringUtil.split(camelCaseTypeNames));
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public void setImmutableFieldTypes(String immutableFieldTypes) {
        this._immutableFieldTypes = ArrayUtil.append(this._immutableFieldTypes, StringUtil.split(immutableFieldTypes));
    }

    public void setShowDebugInformation(boolean showDebugInformation) {
        this._showDebugInformation = showDebugInformation;
    }

    public void visitToken(DetailAST detailAST) {
        if (!this._enabled) {
            return;
        }
        if (!this._showDebugInformation) {
            this._checkConstantName(detailAST);
            return;
        }
        long startTime = System.currentTimeMillis();
        this._checkConstantName(detailAST);
        long endTime = System.currentTimeMillis();
        Class<?> clazz = ((Object)((Object)this)).getClass();
        DebugUtil.increaseProcessingTime(clazz.getSimpleName(), endTime - startTime);
    }

    private void _checkConstantName(DetailAST detailAST) {
        if (!this.mustCheckName(detailAST)) {
            return;
        }
        String regex = null;
        String typeName = DetailASTUtil.getTypeName(detailAST, false);
        if (ArrayUtil.contains(this._camelCaseTypeNames, typeName) || DetailASTUtil.isCollection(detailAST.findFirstToken(13))) {
            regex = _CAMEL_CASE_REGEX;
        } else if (this._isImmutableFieldType(typeName)) {
            regex = _UPPER_CASE_REGEX;
        } else {
            regex = _CONSTANT_NAME_REGEX;
            typeName = null;
        }
        String accessLevel = null;
        DetailAST modifiersDetailAST = detailAST.findFirstToken(5);
        if (modifiersDetailAST.branchContains(61)) {
            accessLevel = "private";
            regex = StringUtil.replaceFirst(regex, '^', "^_");
        } else if (modifiersDetailAST.branchContains(63)) {
            accessLevel = "protected";
        } else if (modifiersDetailAST.branchContains(62)) {
            accessLevel = "public";
        } else {
            return;
        }
        DetailAST nameDetailAST = detailAST.findFirstToken(58);
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(nameDetailAST.getText());
        if (!matcher.find()) {
            if (typeName == null) {
                this.log(nameDetailAST, _MSG_INVALID_CONSTANT_NAME, new Object[]{accessLevel, nameDetailAST.getText(), regex});
            } else {
                this.log(nameDetailAST, _MSG_INVALID_CONSTANT_TYPE_NAME, new Object[]{accessLevel, nameDetailAST.getText(), typeName, regex});
            }
        }
    }

    private boolean _isImmutableFieldType(String typeName) {
        for (String immutableFieldType : this._immutableFieldTypes) {
            if (!typeName.equals(immutableFieldType) && !typeName.startsWith(immutableFieldType + "[]")) continue;
            return true;
        }
        return false;
    }
}

