/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.EmptyLinesCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLEmptyLinesCheck
extends EmptyLinesCheck {
    private static final Pattern _emptyLineBetweenTagsPattern = Pattern.compile("\n(\t*)<[\\w/].*[^-]>(\n\n)(\t*)<(\\w)");
    private static final Pattern _missingEmptyLineAfterCommentPattern = Pattern.compile("[\t ]-->\n[\t<]");
    private static final Pattern _missingEmptyLineBeforeCommentPattern = Pattern.compile(">\n\t+<!--[\n ]");
    private static final Pattern _missingEmptyLinePattern = Pattern.compile("<\\?xml .*\\?>\n<\\w");
    private static final Pattern _redundantEmptyLinePattern = Pattern.compile("<\\?xml .*\\?>\n\n<\\!DOCTYPE");

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.matches(".*\\.(action|function|macro|testcase)") || fileName.endsWith("/content.xml")) {
            return content;
        }
        content = this.fixEmptyLinesInMultiLineTags(content);
        content = this.fixEmptyLinesInNestedTags(content);
        content = this._fixEmptyLinesBetweenTags(fileName, content);
        Matcher matcher = _missingEmptyLinePattern.matcher(content = this._fixMissingEmptyLinesAroundComments(content));
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
        }
        matcher = _redundantEmptyLinePattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        return content;
    }

    private String _fixEmptyLinesBetweenTags(String fileName, String content) {
        if (fileName.startsWith(this.getBaseDirName() + "build") || fileName.matches(".*/(build|tools/).*")) {
            return content;
        }
        if (fileName.endsWith("-log4j-ext.xml") || fileName.endsWith("-log4j.xml") || fileName.endsWith("-logback.xml") || fileName.endsWith("/ivy.xml") || fileName.endsWith("/struts-config.xml") || fileName.endsWith("/tiles-defs.xml")) {
            return this.fixEmptyLinesBetweenTags(content);
        }
        Matcher matcher = _emptyLineBetweenTagsPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.end(1));
        }
        return content;
    }

    private String _fixMissingEmptyLinesAroundComments(String content) {
        Matcher matcher = _missingEmptyLineAfterCommentPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "-->\n", "-->\n\n", matcher.start());
        }
        matcher = _missingEmptyLineBeforeCommentPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, ">\n", ">\n\n", matcher.start());
        }
        return content;
    }
}

