/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.PoshiSourceUtil;
import java.io.IOException;
import java.util.regex.Pattern;

public class PoshiStylingCheck
extends BaseFileCheck {
    private static final Pattern _multiLineCommentsPattern = Pattern.compile("[ \t]/\\*.*?\\*/", 32);
    private static final Pattern _multiLineStringPattern = Pattern.compile("'''.*?'''", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        this._checkLineBreak(fileName, content);
        return content;
    }

    private void _checkLineBreak(String fileName, String content) {
        int x = -1;
        int[] multiLineCommentsPositions = PoshiSourceUtil.getMultiLinePositions(content, _multiLineCommentsPattern);
        int[] multiLineStringPositions = PoshiSourceUtil.getMultiLinePositions(content, _multiLineStringPattern);
        while ((x = content.indexOf(59, x + 1)) != -1) {
            if (content.charAt(x + 1) == '\n' || ToolsUtil.isInsideQuotes(content, x) || PoshiSourceUtil.isInsideMultiLines(this.getLineNumber(content, x), multiLineCommentsPositions) || PoshiSourceUtil.isInsideMultiLines(this.getLineNumber(content, x), multiLineStringPositions)) continue;
            this.addMessage(fileName, "There should be a line break after ';'", this.getLineNumber(content, x));
        }
        return;
    }
}

