/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import aQute.bnd.version.Version;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaUpgradeVersionCheck
extends BaseJavaTermCheck {
    private static final String _INCREMENT_TYPE_MAJOR = "MAJOR";
    private static final String _INCREMENT_TYPE_MICRO = "MICRO";
    private static final String _INCREMENT_TYPE_MINOR = "MINOR";
    private static final String _JAVA_UPGRADE_PROCESS_EXCLUDES = "java.upgrade.process.excludes";
    private static final Pattern _addColumnPattern = Pattern.compile("alter table \\w+ add ");
    private static final Pattern _alterColumnTypePattern = Pattern.compile("AlterColumnType\\(\\s*\"(.+?)\",\\s*\"(\\S+) .+\"\\)");
    private static final Pattern _classNamePattern = Pattern.compile("^new ([\\s\\w.]+)\\(");
    private static final Pattern _dropColumnPattern = Pattern.compile("alter table \\w+ drop column");
    private static final Pattern _tableNamePattern = Pattern.compile("String TABLE_NAME =\\s+\"(.+)\";");

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        JavaClass javaClass = (JavaClass)javaTerm;
        List<String> implementedClassNames = javaClass.getImplementedClassNames();
        if (!implementedClassNames.contains("UpgradeStepRegistrator")) {
            return javaClass.getContent();
        }
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            String name;
            if (!childJavaTerm.isJavaMethod() || !(name = childJavaTerm.getName()).equals("register")) continue;
            this._checkLatestUpgradeVersion(fileName, absolutePath, childJavaTerm, javaClass.getImports(), javaClass.getPackageName());
        }
        return javaClass.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private String _adjustIncrementType(String absolutePath, String content, String className, String upgradePackageName, String incrementType) throws IOException {
        String sqlContent;
        if (content == null) {
            return incrementType;
        }
        if (className != null && content.contains("dependencies/update.sql") && (incrementType = this._adjustIncrementTypeForSQL(sqlContent = this._getSQLFileContent(absolutePath, className), incrementType)).equals(_INCREMENT_TYPE_MAJOR)) {
            return incrementType;
        }
        return this._adjustIncrementTypeForJava(absolutePath, content, upgradePackageName, incrementType);
    }

    private String _adjustIncrementTypeForJava(String absolutePath, String content, String upgradePackageName, String incrementType) throws IOException {
        if ((incrementType = this._adjustIncrementTypeForSQL(content, incrementType)).equals(_INCREMENT_TYPE_MAJOR) || content.contains("AlterColumnName") || content.contains("AlterTableDropColumn") || this._hasColumnTypeAlteration(absolutePath, content, upgradePackageName)) {
            return _INCREMENT_TYPE_MAJOR;
        }
        if (incrementType.equals(_INCREMENT_TYPE_MINOR) || content.contains("AlterTableAddColumn")) {
            return _INCREMENT_TYPE_MINOR;
        }
        return incrementType;
    }

    private String _adjustIncrementTypeForSQL(String content, String incrementType) {
        if (content == null) {
            return incrementType;
        }
        if (content.contains("drop table ")) {
            return _INCREMENT_TYPE_MAJOR;
        }
        Matcher matcher = _dropColumnPattern.matcher(content);
        if (matcher.find()) {
            return _INCREMENT_TYPE_MAJOR;
        }
        if (incrementType.equals(_INCREMENT_TYPE_MINOR) || content.contains("create table ")) {
            return _INCREMENT_TYPE_MINOR;
        }
        matcher = _addColumnPattern.matcher(content);
        if (matcher.find()) {
            return _INCREMENT_TYPE_MINOR;
        }
        return incrementType;
    }

    private void _checkLatestUpgradeVersion(String fileName, String absolutePath, JavaTerm javaTerm, List<String> imports, String upgradePackageName) throws IOException {
        String content = javaTerm.getContent();
        int x = content.lastIndexOf("registry.register(");
        if (x == -1) {
            return;
        }
        List<String> parameterList = JavaSourceUtil.getParameterList(content.substring(x));
        try {
            String expectedIncrementType;
            Version toSchemaVersion = new Version(StringUtil.removeChar(parameterList.get(1), '\"'));
            if (this.isExcludedPath(_JAVA_UPGRADE_PROCESS_EXCLUDES, absolutePath, toSchemaVersion.toString())) {
                return;
            }
            Version fromSchemaVersion = new Version(StringUtil.removeChar(parameterList.get(0), '\"'));
            Version expectedSchemaVersion = this._getExpectedSchemaVersion(fromSchemaVersion, expectedIncrementType = this._getExpectedIncrementType(absolutePath, parameterList.subList(2, parameterList.size()), imports, upgradePackageName));
            if (expectedSchemaVersion.compareTo(toSchemaVersion) > 0) {
                int lineNumber = javaTerm.getLineNumber() + this.getLineNumber(content, x) - 1;
                this.addMessage(fileName, "Expected new schema version: " + expectedSchemaVersion, lineNumber);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private String _getColumnType(String sql, String tableName, String columnName) {
        String columnType;
        int x = sql.indexOf("create table " + tableName);
        if (x == -1) {
            return null;
        }
        x = sql.indexOf(StringBundler.concat("\t", columnName, " "), x + 1);
        if (x == -1) {
            return null;
        }
        int y = x = sql.indexOf(" ", x + 1);
        do {
            if ((y = sql.indexOf(" ", y + 1)) != -1) continue;
            return null;
        } while (this.getLevel(columnType = StringUtil.trim(sql.substring(x, y))) != 0);
        return columnType;
    }

    private String _getExpectedIncrementType(String absolutePath, List<String> upgradeSteps, List<String> imports, String upgradePackageName) throws IOException {
        String incrementType = _INCREMENT_TYPE_MICRO;
        for (String upgradeStep : upgradeSteps) {
            String javaFileContent;
            if (upgradeStep.contains("{\n")) {
                if (!(incrementType = this._adjustIncrementType(absolutePath, upgradeStep, null, upgradePackageName, incrementType)).equals(_INCREMENT_TYPE_MAJOR)) continue;
                return incrementType;
            }
            Matcher matcher = _classNamePattern.matcher(upgradeStep);
            if (!matcher.find()) continue;
            String className = StringUtil.removeChars(matcher.group(1), '\n', ' ', '\t');
            if (!className.contains(".")) {
                for (String importName : imports) {
                    if (!importName.endsWith("." + className)) continue;
                    className = importName;
                    break;
                }
            }
            if (!className.contains(".")) {
                className = StringBundler.concat(upgradePackageName, ".", className);
            }
            if (!(incrementType = this._adjustIncrementType(absolutePath, javaFileContent = this._getJavaFileContent(absolutePath, className), className, upgradePackageName, incrementType)).equals(_INCREMENT_TYPE_MAJOR)) continue;
            return incrementType;
        }
        return incrementType;
    }

    private Version _getExpectedSchemaVersion(Version version, String incrementType) {
        int major = version.getMajor();
        int micro = version.getMicro();
        int minor = version.getMinor();
        if (incrementType.equals(_INCREMENT_TYPE_MAJOR)) {
            ++major;
            micro = 0;
            minor = 0;
        } else if (incrementType.equals(_INCREMENT_TYPE_MINOR)) {
            micro = 0;
            ++minor;
        } else if (incrementType.equals(_INCREMENT_TYPE_MICRO)) {
            ++micro;
        }
        return new Version(major, minor, micro);
    }

    private String _getJavaFileContent(String absolutePath, String className) throws IOException {
        int x = absolutePath.lastIndexOf("/com/liferay/");
        String fileLocation = StringBundler.concat(absolutePath.substring(0, x + 1), StringUtil.replace(className, '.', '/'), ".java");
        File file = new File(fileLocation);
        if (file.exists()) {
            return FileUtil.read(file);
        }
        return null;
    }

    private String _getSQLFileContent(String absolutePath, String className) throws IOException {
        String fileLocation = StringUtil.replaceLast(absolutePath, "/java/", "/resources/");
        int x = fileLocation.lastIndexOf("/com/liferay/");
        int y = className.lastIndexOf(46);
        String packageName = className.substring(0, y);
        File file = new File(fileLocation = StringBundler.concat(fileLocation.substring(0, x + 1), StringUtil.replace(packageName, '.', '/'), "/dependencies/update.sql"));
        if (file.exists()) {
            return FileUtil.read(file);
        }
        return null;
    }

    private String _getTableName(String absolutePath, String content, String upgradePackageName, String tableClassName) throws IOException {
        if (!tableClassName.endsWith(".class")) {
            return null;
        }
        tableClassName = tableClassName.substring(0, tableClassName.length() - 6);
        Pattern pattern = Pattern.compile(StringBundler.concat("import (.*\\.", tableClassName, ");"));
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return null;
        }
        tableClassName = matcher.group(1);
        if (!tableClassName.startsWith(upgradePackageName)) {
            return null;
        }
        String tableClassContent = this._getJavaFileContent(absolutePath, tableClassName);
        if (tableClassContent == null) {
            return null;
        }
        matcher = _tableNamePattern.matcher(tableClassContent);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private boolean _hasColumnTypeAlteration(String absolutePath, String content, String upgradePackageName) throws IOException {
        int x = -1;
        while ((x = content.indexOf("\talter(", x + 1)) != -1) {
            List<String> parameterList = JavaSourceUtil.getParameterList(content.substring(x));
            String tableName = this._getTableName(absolutePath, content, upgradePackageName, parameterList.get(0));
            if (tableName == null) continue;
            for (int i = 1; i < parameterList.size(); ++i) {
                String parameter = parameterList.get(i);
                Matcher matcher = _alterColumnTypePattern.matcher(parameter);
                if (!matcher.find() || !this._hasColumnTypeAlteration(absolutePath, tableName, matcher.group(1), matcher.group(2))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _hasColumnTypeAlteration(String absolutePath, String tableName, String columnName, String newType) throws IOException {
        NaturalOrderStringComparator comparator;
        int y;
        int x = absolutePath.lastIndexOf("/modules/");
        String tablesSQLFileLocation = absolutePath.substring(x + 1, (y = absolutePath.lastIndexOf("/src/")) + 1) + "src/main/resources/META-INF/sql/tables.sql";
        String tablesSQLContent = this.getPortalContent(tablesSQLFileLocation, true);
        if (tablesSQLContent == null) {
            return false;
        }
        String oldType = this._getColumnType(tablesSQLContent, tableName, columnName);
        if (oldType == null || oldType.equals(newType) || oldType.startsWith("VARCHAR") && newType.equals("TEXT")) {
            return false;
        }
        return !oldType.startsWith("VARCHAR") || !newType.startsWith("VARCHAR") || (comparator = new NaturalOrderStringComparator()).compare(oldType, newType) >= 0;
    }
}

